/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.sms;

import cn.javaer.aliyun.sms.CheckedSupplier;
import cn.javaer.aliyun.sms.CheckedVoid;
import cn.javaer.aliyun.sms.SmsException;
import cn.javaer.aliyun.sms.SmsTemplate;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

class Utils {
    private static final String SUCCESS_CODE = "OK";
    private static final String PHONE_NUMBER_REGEX = "1\\d{10}";

    Utils() {
    }

    static int randomCode() {
        return 100000 + ThreadLocalRandom.current().nextInt(900000);
    }

    static String toJsonStr(Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append('\"').append(entry.getKey().replace("\"", "\\\"")).append('\"').append(':').append('\"').append(entry.getValue().replace("\"", "\\\"")).append('\"').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    static void checkSmsTemplate(SmsTemplate template) {
        if (null == template.getSignName() || template.getSignName().isEmpty()) {
            throw new IllegalArgumentException("SmsTemplate signName must be not empty");
        }
        if (null == template.getTemplateCode() || template.getTemplateCode().isEmpty()) {
            throw new IllegalArgumentException("SmsTemplate templateCode must be not empty");
        }
        if (null == template.getPhoneNumbers() || template.getPhoneNumbers().isEmpty()) {
            throw new IllegalArgumentException("SmsTemplate phoneNumbers must be not empty");
        }
    }

    static void checkSmsResponse(SendSmsResponse response) {
        if (null == response) {
            throw new SmsException("Response is null");
        }
        if (!SUCCESS_CODE.equalsIgnoreCase(response.getCode())) {
            throw new SmsException("Response code is '" + response.getCode() + "'");
        }
    }

    static void checkPhoneNumber(String phoneNumber) {
        if (null == phoneNumber || !phoneNumber.matches(PHONE_NUMBER_REGEX)) {
            throw new IllegalArgumentException("Invalid phone number");
        }
    }

    static void checkNotEmpty(String str, String message) {
        if (null == str || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    static <T> T tryChecked(CheckedSupplier<T> fun) {
        try {
            return fun.get();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SmsException(e);
        }
    }

    static void tryChecked(CheckedVoid fun) {
        try {
            fun.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SmsException(e);
        }
    }
}

