/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectGroupByClause
extends SQLObjectImpl {
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    private SQLExpr having;
    private boolean withRollUp = false;
    private boolean withCube = false;
    private boolean distinct = false;
    private boolean paren = false;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
            this.acceptChild(visitor, this.having);
        }
        visitor.endVisit(this);
    }

    public boolean isWithRollUp() {
        return this.withRollUp;
    }

    public void setWithRollUp(boolean withRollUp) {
        this.withRollUp = withRollUp;
    }

    public boolean isWithCube() {
        return this.withCube;
    }

    public void setWithCube(boolean withCube) {
        this.withCube = withCube;
    }

    public SQLExpr getHaving() {
        return this.having;
    }

    public void setHaving(SQLExpr having) {
        if (having != null) {
            having.setParent(this);
        }
        this.having = having;
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public void addItem(SQLExpr sqlExpr) {
        if (sqlExpr != null) {
            sqlExpr.setParent(this);
            this.items.add(sqlExpr);
        }
    }

    @Override
    public SQLSelectGroupByClause clone() {
        SQLSelectGroupByClause x = new SQLSelectGroupByClause();
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(x);
            x.items.add(item2);
        }
        if (this.having != null) {
            x.setHaving(this.having.clone());
        }
        x.withRollUp = this.withRollUp;
        x.withCube = this.withCube;
        return x;
    }

    public void addHaving(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        this.having = this.having == null ? condition : SQLBinaryOpExpr.and(this.having, condition);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isParen() {
        return this.paren;
    }

    public void setParen(boolean paren) {
        this.paren = paren;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelectGroupByClause group = (SQLSelectGroupByClause)o;
        if (this.withRollUp != group.withRollUp) {
            return false;
        }
        if (this.withCube != group.withCube) {
            return false;
        }
        if (this.distinct != group.distinct) {
            return false;
        }
        if (this.paren != group.paren) {
            return false;
        }
        if (!this.items.equals(group.items)) {
            return false;
        }
        return this.having != null ? this.having.equals(group.having) : group.having == null;
    }

    public int hashCode() {
        int result = this.items != null ? this.items.hashCode() : 0;
        result = 31 * result + (this.having != null ? this.having.hashCode() : 0);
        result = 31 * result + (this.withRollUp ? 1 : 0);
        result = 31 * result + (this.withCube ? 1 : 0);
        result = 31 * result + (this.distinct ? 1 : 0);
        result = 31 * result + (this.paren ? 1 : 0);
        return result;
    }
}

