/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.ability.ClientAbilities;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.config.remote.request.ClientConfigMetricRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigBatchListenRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigChangeNotifyRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ClientConfigMetricResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigChangeBatchListenResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigChangeNotifyResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.impl.CacheData;
import com.alibaba.nacos.client.config.impl.ConfigTransportClient;
import com.alibaba.nacos.client.config.impl.Limiter;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.ServerlistChangeEvent;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.EnvUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.alibaba.nacos.shaded.com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ClientWorker
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ClientWorker.class);
    private static final String NOTIFY_HEADER = "notify";
    private static final String TAG_PARAM = "tag";
    private static final String APP_NAME_PARAM = "appName";
    private static final String BETAIPS_PARAM = "betaIps";
    private static final String TYPE_PARAM = "type";
    private static final String ENCRYPTED_DATA_KEY_PARAM = "encryptedDataKey";
    private final AtomicReference<Map<String, CacheData>> cacheMap = new AtomicReference(new HashMap());
    private final ConfigFilterChainManager configFilterChainManager;
    private String uuid = UUID.randomUUID().toString();
    private long timeout;
    private ConfigRpcTransportClient agent;
    private int taskPenaltyTime;
    private boolean enableRemoteSyncConfig = false;
    private static final int MIN_THREAD_NUM = 2;
    private static final int THREAD_MULTIPLE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(String dataId, String group, List<? extends Listener> listeners) throws NacosException {
        CacheData cache;
        group = this.blank2defaultGroup(group);
        CacheData cacheData = cache = this.addCacheDataIfAbsent(dataId, group);
        synchronized (cacheData) {
            for (Listener listener : listeners) {
                cache.addListener(listener);
            }
            cache.setDiscard(false);
            cache.setSyncWithServer(false);
            this.agent.notifyListenConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenantListeners(String dataId, String group, List<? extends Listener> listeners) throws NacosException {
        CacheData cache;
        group = this.blank2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cacheData = cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        synchronized (cacheData) {
            for (Listener listener : listeners) {
                cache.addListener(listener);
            }
            cache.setDiscard(false);
            cache.setSyncWithServer(false);
            this.agent.notifyListenConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenantListenersWithContent(String dataId, String group, String content, String encryptedDataKey, List<? extends Listener> listeners) throws NacosException {
        CacheData cache;
        group = this.blank2defaultGroup(group);
        String tenant = this.agent.getTenant();
        CacheData cacheData = cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        synchronized (cacheData) {
            cache.setEncryptedDataKey(encryptedDataKey);
            cache.setContent(content);
            for (Listener listener : listeners) {
                cache.addListener(listener);
            }
            cache.setDiscard(false);
            cache.setSyncWithServer(false);
            this.agent.notifyListenConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String dataId, String group, Listener listener) {
        CacheData cache = this.getCache(dataId, group = this.blank2defaultGroup(group));
        if (null != cache) {
            CacheData cacheData = cache;
            synchronized (cacheData) {
                cache.removeListener(listener);
                if (cache.getListeners().isEmpty()) {
                    cache.setSyncWithServer(false);
                    cache.setDiscard(true);
                    this.agent.removeCache(dataId, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTenantListener(String dataId, String group, Listener listener) {
        String tenant;
        CacheData cache = this.getCache(dataId, group = this.blank2defaultGroup(group), tenant = this.agent.getTenant());
        if (null != cache) {
            CacheData cacheData = cache;
            synchronized (cacheData) {
                cache.removeListener(listener);
                if (cache.getListeners().isEmpty()) {
                    cache.setSyncWithServer(false);
                    cache.setDiscard(true);
                    this.agent.removeCache(dataId, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [unsubscribe] {}", (Object)this.agent.getName(), (Object)groupKey);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
    }

    public boolean removeConfig(String dataId, String group, String tenant, String tag) throws NacosException {
        return this.agent.removeConfig(dataId, group, tenant, tag);
    }

    public boolean publishConfig(String dataId, String group, String tenant, String appName, String tag, String betaIps, String content, String encryptedDataKey, String casMd5, String type) throws NacosException {
        return this.agent.publishConfig(dataId, group, tenant, appName, tag, betaIps, content, encryptedDataKey, casMd5, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKey(dataId, group);
        cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                int taskId = this.cacheMap.get().size() / (int)ParamUtil.getPerTaskConfigSize();
                cache.setTaskId(taskId);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [subscribe] {}", (Object)this.agent.getName(), (Object)key);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) throws NacosException {
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group, tenant);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                cache = new CacheData(this.configFilterChainManager, this.agent.getName(), dataId, group, tenant);
                int taskId = this.cacheMap.get().size() / (int)ParamUtil.getPerTaskConfigSize();
                cache.setTaskId(taskId);
                if (this.enableRemoteSyncConfig) {
                    ConfigResponse response = this.getServerConfig(dataId, group, tenant, 3000L, false);
                    cache.setEncryptedDataKey(response.getEncryptedDataKey());
                    cache.setContent(response.getContent());
                }
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        LOGGER.info("[{}] [subscribe] {}", (Object)this.agent.getName(), (Object)key);
        MetricsMonitor.getListenConfigCountMonitor().set((double)this.cacheMap.get().size());
        return cache;
    }

    public CacheData getCache(String dataId, String group) {
        return this.getCache(dataId, group, TenantUtil.getUserTenantForAcm());
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKeyTenant(dataId, group, tenant));
    }

    public ConfigResponse getServerConfig(String dataId, String group, String tenant, long readTimeout, boolean notify) throws NacosException {
        if (StringUtils.isBlank(group)) {
            group = "DEFAULT_GROUP";
        }
        return this.agent.queryConfig(dataId, group, tenant, readTimeout, notify);
    }

    private String blank2defaultGroup(String group) {
        return StringUtils.isBlank(group) ? "DEFAULT_GROUP" : group.trim();
    }

    public ClientWorker(ConfigFilterChainManager configFilterChainManager, ServerListManager serverListManager, NacosClientProperties properties) throws NacosException {
        this.configFilterChainManager = configFilterChainManager;
        this.init(properties);
        this.agent = new ConfigRpcTransportClient(properties, serverListManager);
        int count = ThreadUtils.getSuitableThreadCount(1);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(Math.max(count, 2), r -> {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.Worker");
            t.setDaemon(true);
            return t;
        });
        this.agent.setExecutor(executorService);
        this.agent.start();
    }

    private void refreshContentAndCheck(String groupKey) {
        CacheData cache = this.cacheMap.get().get(groupKey);
        if (cache != null) {
            boolean notify = !cache.isInitializing();
            this.refreshContentAndCheck(cache, notify);
        }
    }

    private void refreshContentAndCheck(CacheData cacheData, boolean notify) {
        try {
            ConfigResponse response = this.getServerConfig(cacheData.dataId, cacheData.group, cacheData.tenant, 3000L, notify);
            cacheData.setEncryptedDataKey(response.getEncryptedDataKey());
            cacheData.setContent(response.getContent());
            if (null != response.getConfigType()) {
                cacheData.setType(response.getConfigType());
            }
            if (notify) {
                LOGGER.info("[{}] [data-received] dataId={}, group={}, tenant={}, md5={}, content={}, type={}", new Object[]{this.agent.getName(), cacheData.dataId, cacheData.group, cacheData.tenant, cacheData.getMd5(), ContentUtils.truncateContent(response.getContent()), response.getConfigType()});
            }
            cacheData.checkListenerMd5();
        }
        catch (Exception e) {
            LOGGER.error("refresh content and check md5 fail ,dataId={},group={},tenant={} ", new Object[]{cacheData.dataId, cacheData.group, cacheData.tenant, e});
        }
    }

    private void init(NacosClientProperties properties) {
        this.timeout = Math.max(ConvertUtils.toInt(properties.getProperty("configLongPollTimeout"), 30000), 10000);
        this.taskPenaltyTime = ConvertUtils.toInt(properties.getProperty("configRetryTime"), 2000);
        this.enableRemoteSyncConfig = Boolean.parseBoolean(properties.getProperty("enableRemoteSyncConfig"));
    }

    private Map<String, Object> getMetrics(List<ClientConfigMetricRequest.MetricsKey> metricsKeys) {
        HashMap<String, Object> metric = new HashMap<String, Object>(16);
        metric.put("listenConfigSize", String.valueOf(this.cacheMap.get().size()));
        metric.put("clientVersion", VersionUtils.getFullClientVersion());
        metric.put("snapshotDir", LocalConfigInfoProcessor.LOCAL_SNAPSHOT_PATH);
        boolean isFixServer = this.agent.serverListManager.isFixed;
        metric.put("isFixedServer", isFixServer);
        metric.put("addressUrl", this.agent.serverListManager.addressServerUrl);
        metric.put("serverUrls", this.agent.serverListManager.getUrlString());
        Map<ClientConfigMetricRequest.MetricsKey, Object> metricValues = this.getMetricsValue(metricsKeys);
        metric.put("metricValues", metricValues);
        HashMap<String, Object> metrics = new HashMap<String, Object>(1);
        metrics.put(this.uuid, JacksonUtils.toJson(metric));
        return metrics;
    }

    private Map<ClientConfigMetricRequest.MetricsKey, Object> getMetricsValue(List<ClientConfigMetricRequest.MetricsKey> metricsKeys) {
        if (metricsKeys == null) {
            return null;
        }
        HashMap<ClientConfigMetricRequest.MetricsKey, Object> values = new HashMap<ClientConfigMetricRequest.MetricsKey, Object>(16);
        for (ClientConfigMetricRequest.MetricsKey metricsKey : metricsKeys) {
            if ("cacheData".equals(metricsKey.getType())) {
                CacheData cacheData = this.cacheMap.get().get(metricsKey.getKey());
                values.putIfAbsent(metricsKey, cacheData == null ? null : cacheData.getContent() + ":" + cacheData.getMd5());
            }
            if (!"snapshotData".equals(metricsKey.getType())) continue;
            String[] configStr = GroupKey.parseKey(metricsKey.getKey());
            String snapshot = LocalConfigInfoProcessor.getSnapshot(this.agent.getName(), configStr[0], configStr[1], configStr[2]);
            values.putIfAbsent(metricsKey, snapshot == null ? null : snapshot + ":" + MD5Utils.md5Hex(snapshot, "UTF-8"));
        }
        return values;
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        if (this.agent != null) {
            this.agent.shutdown();
        }
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public boolean isHealthServer() {
        return this.agent.isHealthServer();
    }

    public String getAgentName() {
        return this.agent.getName();
    }

    public ConfigTransportClient getAgent() {
        return this.agent;
    }

    public class ConfigRpcTransportClient
    extends ConfigTransportClient {
        private final BlockingQueue<Object> listenExecutebell;
        private Object bellItem;
        private long lastAllSyncTime;
        private static final long ALL_SYNC_INTERNAL = 300000L;

        public ConfigRpcTransportClient(NacosClientProperties properties, ServerListManager serverListManager) {
            super(properties, serverListManager);
            this.listenExecutebell = new ArrayBlockingQueue<Object>(1);
            this.bellItem = new Object();
            this.lastAllSyncTime = System.currentTimeMillis();
        }

        private ConnectionType getConnectionType() {
            return ConnectionType.GRPC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() throws NacosException {
            super.shutdown();
            Set<Map.Entry<String, RpcClient>> set = RpcClientFactory.getAllClientEntries();
            synchronized (set) {
                LOGGER.info("Trying to shutdown transport client {}", (Object)this);
                Set<Map.Entry<String, RpcClient>> allClientEntries = RpcClientFactory.getAllClientEntries();
                Iterator<Map.Entry<String, RpcClient>> iterator = allClientEntries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, RpcClient> entry = iterator.next();
                    if (!entry.getKey().startsWith(ClientWorker.this.uuid)) continue;
                    LOGGER.info("Trying to shutdown rpc client {}", (Object)entry.getKey());
                    try {
                        entry.getValue().shutdown();
                    }
                    catch (NacosException nacosException) {
                        nacosException.printStackTrace();
                    }
                    LOGGER.info("Remove rpc client {}", (Object)entry.getKey());
                    iterator.remove();
                }
                LOGGER.info("Shutdown executor {}", (Object)this.executor);
                this.executor.shutdown();
                Map stringCacheDataMap = (Map)ClientWorker.this.cacheMap.get();
                for (Map.Entry entry : stringCacheDataMap.entrySet()) {
                    ((CacheData)entry.getValue()).setSyncWithServer(false);
                }
            }
        }

        private Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>(2, 1.0f);
            labels.put("source", "sdk");
            labels.put("module", "config");
            labels.put("AppName", AppNameUtils.getAppName());
            labels.put("Vipserver-Tag", EnvUtil.getSelfVipserverTag());
            labels.put("Amory-Tag", EnvUtil.getSelfAmoryTag());
            labels.put("Location-Tag", EnvUtil.getSelfLocationTag());
            return labels;
        }

        private void initRpcClientHandler(final RpcClient rpcClientInner) {
            rpcClientInner.registerServerRequestHandler(request -> {
                if (request instanceof ConfigChangeNotifyRequest) {
                    ConfigChangeNotifyRequest configChangeNotifyRequest = (ConfigChangeNotifyRequest)request;
                    LOGGER.info("[{}] [server-push] config changed. dataId={}, group={},tenant={}", new Object[]{rpcClientInner.getName(), configChangeNotifyRequest.getDataId(), configChangeNotifyRequest.getGroup(), configChangeNotifyRequest.getTenant()});
                    String groupKey = GroupKey.getKeyTenant(configChangeNotifyRequest.getDataId(), configChangeNotifyRequest.getGroup(), configChangeNotifyRequest.getTenant());
                    CacheData cacheData = (CacheData)((Map)ClientWorker.this.cacheMap.get()).get(groupKey);
                    if (cacheData != null) {
                        CacheData cacheData2 = cacheData;
                        synchronized (cacheData2) {
                            cacheData.getLastModifiedTs().set(System.currentTimeMillis());
                            cacheData.setSyncWithServer(false);
                            this.notifyListenConfig();
                        }
                    }
                    return new ConfigChangeNotifyResponse();
                }
                return null;
            });
            rpcClientInner.registerServerRequestHandler(request -> {
                if (request instanceof ClientConfigMetricRequest) {
                    ClientConfigMetricResponse response = new ClientConfigMetricResponse();
                    response.setMetrics(ClientWorker.this.getMetrics(((ClientConfigMetricRequest)request).getMetricsKeys()));
                    return response;
                }
                return null;
            });
            rpcClientInner.registerConnectionListener(new ConnectionEventListener(){

                @Override
                public void onConnected() {
                    LOGGER.info("[{}] Connected,notify listen context...", (Object)rpcClientInner.getName());
                    ConfigRpcTransportClient.this.notifyListenConfig();
                }

                @Override
                public void onDisConnect() {
                    String taskId = rpcClientInner.getLabels().get("taskId");
                    LOGGER.info("[{}] DisConnected,clear listen context...", (Object)rpcClientInner.getName());
                    Collection values = ((Map)ClientWorker.this.cacheMap.get()).values();
                    for (CacheData cacheData : values) {
                        if (StringUtils.isNotBlank(taskId)) {
                            if (!Integer.valueOf(taskId).equals(cacheData.getTaskId())) continue;
                            cacheData.setSyncWithServer(false);
                            continue;
                        }
                        cacheData.setSyncWithServer(false);
                    }
                }
            });
            rpcClientInner.serverListFactory(new ServerListFactory(){

                @Override
                public String genNextServer() {
                    return ConfigRpcTransportClient.this.serverListManager.getNextServerAddr();
                }

                @Override
                public String getCurrentServer() {
                    return ConfigRpcTransportClient.this.serverListManager.getCurrentServerAddr();
                }

                @Override
                public List<String> getServerList() {
                    return ConfigRpcTransportClient.this.serverListManager.getServerUrls();
                }
            });
            NotifyCenter.registerSubscriber(new Subscriber<ServerlistChangeEvent>(){

                @Override
                public void onEvent(ServerlistChangeEvent event) {
                    rpcClientInner.onServerListChange();
                }

                @Override
                public Class<? extends Event> subscribeType() {
                    return ServerlistChangeEvent.class;
                }
            });
        }

        @Override
        public void startInternal() {
            this.executor.schedule(() -> {
                while (!this.executor.isShutdown() && !this.executor.isTerminated()) {
                    try {
                        this.listenExecutebell.poll(5L, TimeUnit.SECONDS);
                        if (this.executor.isShutdown() || this.executor.isTerminated()) continue;
                        this.executeConfigListen();
                    }
                    catch (Throwable e) {
                        LOGGER.error("[ rpc listen execute ] [rpc listen] exception", e);
                    }
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        public String getName() {
            return this.serverListManager.getName();
        }

        @Override
        public void notifyListenConfig() {
            this.listenExecutebell.offer(this.bellItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void executeConfigListen() {
            String taskId;
            HashMap<String, LinkedList<CacheData>> listenCachesMap = new HashMap<String, LinkedList<CacheData>>(16);
            HashMap<String, LinkedList<CacheData>> removeListenCachesMap = new HashMap<String, LinkedList<CacheData>>(16);
            long now = System.currentTimeMillis();
            boolean needAllSync = now - this.lastAllSyncTime >= 300000L;
            Iterator iterator = ((Map)ClientWorker.this.cacheMap.get()).values().iterator();
            while (iterator.hasNext()) {
                CacheData cache;
                CacheData cacheData = cache = (CacheData)iterator.next();
                synchronized (cacheData) {
                    List<CacheData> cacheDatas;
                    if (cache.isSyncWithServer()) {
                        cache.checkListenerMd5();
                        if (!needAllSync) {
                            continue;
                        }
                    }
                    if (!cache.isDiscard()) {
                        if (!cache.isUseLocalConfigInfo()) {
                            cacheDatas = (LinkedList<CacheData>)listenCachesMap.get(String.valueOf(cache.getTaskId()));
                            if (cacheDatas == null) {
                                cacheDatas = new LinkedList<CacheData>();
                                listenCachesMap.put(String.valueOf(cache.getTaskId()), (LinkedList<CacheData>)cacheDatas);
                            }
                            cacheDatas.add(cache);
                        }
                    } else if (cache.isDiscard() && !cache.isUseLocalConfigInfo()) {
                        cacheDatas = (List)removeListenCachesMap.get(String.valueOf(cache.getTaskId()));
                        if (cacheDatas == null) {
                            cacheDatas = new LinkedList();
                            removeListenCachesMap.put(String.valueOf(cache.getTaskId()), (LinkedList<CacheData>)cacheDatas);
                        }
                        cacheDatas.add(cache);
                    }
                }
            }
            boolean hasChangedKeys = false;
            if (!listenCachesMap.isEmpty()) {
                for (Map.Entry entry : listenCachesMap.entrySet()) {
                    taskId = (String)entry.getKey();
                    HashMap<String, Long> timestampMap = new HashMap<String, Long>(listenCachesMap.size() * 2);
                    List listenCaches = (List)entry.getValue();
                    for (CacheData cacheData : listenCaches) {
                        timestampMap.put(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant), cacheData.getLastModifiedTs().longValue());
                    }
                    ConfigBatchListenRequest configChangeListenRequest = this.buildConfigRequest(listenCaches);
                    configChangeListenRequest.setListen(true);
                    try {
                        RpcClient rpcClient = this.ensureRpcClient(taskId);
                        ConfigChangeBatchListenResponse configChangeBatchListenResponse = (ConfigChangeBatchListenResponse)this.requestProxy(rpcClient, configChangeListenRequest);
                        if (!configChangeBatchListenResponse.isSuccess()) continue;
                        HashSet<String> changeKeys = new HashSet<String>();
                        if (!CollectionUtils.isEmpty(configChangeBatchListenResponse.getChangedConfigs())) {
                            hasChangedKeys = true;
                            for (ConfigChangeBatchListenResponse.ConfigContext changeConfig : configChangeBatchListenResponse.getChangedConfigs()) {
                                String changeKey = GroupKey.getKeyTenant(changeConfig.getDataId(), changeConfig.getGroup(), changeConfig.getTenant());
                                changeKeys.add(changeKey);
                                ClientWorker.this.refreshContentAndCheck(changeKey);
                            }
                        }
                        for (CacheData cacheData : listenCaches) {
                            String groupKey = GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.getTenant());
                            if (!changeKeys.contains(groupKey)) {
                                CacheData cacheData2 = cacheData;
                                synchronized (cacheData2) {
                                    if (!cacheData.getListeners().isEmpty()) {
                                        Long previousTimesStamp = (Long)timestampMap.get(groupKey);
                                        if (previousTimesStamp != null && !cacheData.getLastModifiedTs().compareAndSet(previousTimesStamp, System.currentTimeMillis())) {
                                            continue;
                                        }
                                        cacheData.setSyncWithServer(true);
                                    }
                                }
                            }
                            cacheData.setInitializing(false);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Async listen config change error ", (Throwable)e);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (!removeListenCachesMap.isEmpty()) {
                for (Map.Entry entry : removeListenCachesMap.entrySet()) {
                    taskId = (String)entry.getKey();
                    List removeListenCaches = (List)entry.getValue();
                    ConfigBatchListenRequest configChangeListenRequest = this.buildConfigRequest(removeListenCaches);
                    configChangeListenRequest.setListen(false);
                    try {
                        RpcClient rpcClient = this.ensureRpcClient(taskId);
                        boolean removeSuccess = this.unListenConfigChange(rpcClient, configChangeListenRequest);
                        if (removeSuccess) {
                            for (CacheData cacheData : removeListenCaches) {
                                Iterator<ConfigChangeBatchListenResponse.ConfigContext> iterator2 = cacheData;
                                synchronized (iterator2) {
                                    if (cacheData.isDiscard()) {
                                        ClientWorker.this.removeCache(cacheData.dataId, cacheData.group, cacheData.tenant);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("async remove listen config change error ", (Throwable)e);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (needAllSync) {
                this.lastAllSyncTime = now;
            }
            if (hasChangedKeys) {
                this.notifyListenConfig();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RpcClient ensureRpcClient(String taskId) throws NacosException {
            ClientWorker clientWorker = ClientWorker.this;
            synchronized (clientWorker) {
                Map<String, String> labels = this.getLabels();
                HashMap<String, String> newLabels = new HashMap<String, String>(labels);
                newLabels.put("taskId", taskId);
                RpcClient rpcClient = RpcClientFactory.createClient(ClientWorker.this.uuid + "_config-" + taskId, this.getConnectionType(), newLabels);
                if (rpcClient.isWaitInitiated()) {
                    this.initRpcClientHandler(rpcClient);
                    rpcClient.setTenant(this.getTenant());
                    rpcClient.clientAbilities(this.initAbilities());
                    rpcClient.start();
                }
                return rpcClient;
            }
        }

        private ClientAbilities initAbilities() {
            ClientAbilities clientAbilities = new ClientAbilities();
            clientAbilities.getRemoteAbility().setSupportRemoteConnection(true);
            clientAbilities.getConfigAbility().setSupportRemoteMetrics(true);
            return clientAbilities;
        }

        private ConfigBatchListenRequest buildConfigRequest(List<CacheData> caches) {
            ConfigBatchListenRequest configChangeListenRequest = new ConfigBatchListenRequest();
            for (CacheData cacheData : caches) {
                configChangeListenRequest.addConfigListenContext(cacheData.group, cacheData.dataId, cacheData.tenant, cacheData.getMd5());
            }
            return configChangeListenRequest;
        }

        @Override
        public void removeCache(String dataId, String group) {
            this.notifyListenConfig();
        }

        private boolean unListenConfigChange(RpcClient rpcClient, ConfigBatchListenRequest configChangeListenRequest) throws NacosException {
            ConfigChangeBatchListenResponse response = (ConfigChangeBatchListenResponse)this.requestProxy(rpcClient, configChangeListenRequest);
            return response.isSuccess();
        }

        @Override
        public ConfigResponse queryConfig(String dataId, String group, String tenant, long readTimeouts, boolean notify) throws NacosException {
            CacheData cacheData;
            ConfigQueryRequest request = ConfigQueryRequest.build(dataId, group, tenant);
            request.putHeader(ClientWorker.NOTIFY_HEADER, String.valueOf(notify));
            RpcClient rpcClient = this.getOneRunningClient();
            if (notify && (cacheData = (CacheData)((Map)ClientWorker.this.cacheMap.get()).get(GroupKey.getKeyTenant(dataId, group, tenant))) != null) {
                rpcClient = this.ensureRpcClient(String.valueOf(cacheData.getTaskId()));
            }
            ConfigQueryResponse response = (ConfigQueryResponse)this.requestProxy(rpcClient, request, readTimeouts);
            ConfigResponse configResponse = new ConfigResponse();
            if (response.isSuccess()) {
                LocalConfigInfoProcessor.saveSnapshot(this.getName(), dataId, group, tenant, response.getContent());
                configResponse.setContent(response.getContent());
                String configType = StringUtils.isNotBlank(response.getContentType()) ? response.getContentType() : ConfigType.TEXT.getType();
                configResponse.setConfigType(configType);
                String encryptedDataKey = response.getEncryptedDataKey();
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(ClientWorker.this.agent.getName(), dataId, group, tenant, encryptedDataKey);
                configResponse.setEncryptedDataKey(encryptedDataKey);
                return configResponse;
            }
            if (response.getErrorCode() == 300) {
                LocalConfigInfoProcessor.saveSnapshot(this.getName(), dataId, group, tenant, null);
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(ClientWorker.this.agent.getName(), dataId, group, tenant, null);
                return configResponse;
            }
            if (response.getErrorCode() == 400) {
                LOGGER.error("[{}] [sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{this.getName(), dataId, group, tenant});
                throw new NacosException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            LOGGER.error("[{}] [sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{this.getName(), dataId, group, tenant, response});
            throw new NacosException(response.getErrorCode(), "http error, code=" + response.getErrorCode() + ",msg=" + response.getMessage() + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
        }

        private Response requestProxy(RpcClient rpcClientInner, Request request) throws NacosException {
            return this.requestProxy(rpcClientInner, request, 3000L);
        }

        private Response requestProxy(RpcClient rpcClientInner, Request request, long timeoutMills) throws NacosException {
            try {
                request.putAllHeader(super.getSecurityHeaders(this.resourceBuild(request)));
                request.putAllHeader(super.getCommonHeader());
            }
            catch (Exception e) {
                throw new NacosException(-400, (Throwable)e);
            }
            JsonObject asJsonObjectTemp = new Gson().toJsonTree(request).getAsJsonObject();
            asJsonObjectTemp.remove("headers");
            asJsonObjectTemp.remove("requestId");
            boolean limit = Limiter.isLimit(request.getClass() + asJsonObjectTemp.toString());
            if (limit) {
                throw new NacosException(-503, "More than client-side current limit threshold");
            }
            return rpcClientInner.request(request, timeoutMills);
        }

        private RequestResource resourceBuild(Request request) {
            if (request instanceof ConfigQueryRequest) {
                String tenant = ((ConfigQueryRequest)request).getTenant();
                String group = ((ConfigQueryRequest)request).getGroup();
                String dataId = ((ConfigQueryRequest)request).getDataId();
                return this.buildResource(tenant, group, dataId);
            }
            if (request instanceof ConfigPublishRequest) {
                String tenant = ((ConfigPublishRequest)request).getTenant();
                String group = ((ConfigPublishRequest)request).getGroup();
                String dataId = ((ConfigPublishRequest)request).getDataId();
                return this.buildResource(tenant, group, dataId);
            }
            if (request instanceof ConfigRemoveRequest) {
                String tenant = ((ConfigRemoveRequest)request).getTenant();
                String group = ((ConfigRemoveRequest)request).getGroup();
                String dataId = ((ConfigRemoveRequest)request).getDataId();
                return this.buildResource(tenant, group, dataId);
            }
            return RequestResource.configBuilder().build();
        }

        RpcClient getOneRunningClient() throws NacosException {
            return this.ensureRpcClient("0");
        }

        @Override
        public boolean publishConfig(String dataId, String group, String tenant, String appName, String tag, String betaIps, String content, String encryptedDataKey, String casMd5, String type) throws NacosException {
            try {
                ConfigPublishRequest request = new ConfigPublishRequest(dataId, group, tenant, content);
                request.setCasMd5(casMd5);
                request.putAdditionalParam(ClientWorker.TAG_PARAM, tag);
                request.putAdditionalParam(ClientWorker.APP_NAME_PARAM, appName);
                request.putAdditionalParam(ClientWorker.BETAIPS_PARAM, betaIps);
                request.putAdditionalParam(ClientWorker.TYPE_PARAM, type);
                request.putAdditionalParam(ClientWorker.ENCRYPTED_DATA_KEY_PARAM, encryptedDataKey == null ? "" : encryptedDataKey);
                ConfigPublishResponse response = (ConfigPublishResponse)this.requestProxy(this.getOneRunningClient(), request);
                if (!response.isSuccess()) {
                    LOGGER.warn("[{}] [publish-single] fail, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.getName(), dataId, group, tenant, response.getErrorCode(), response.getMessage()});
                    return false;
                }
                LOGGER.info("[{}] [publish-single] ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.getName(), dataId, group, tenant, "unknown", e.getMessage()});
                return false;
            }
        }

        @Override
        public boolean removeConfig(String dataId, String group, String tenant, String tag) throws NacosException {
            ConfigRemoveRequest request = new ConfigRemoveRequest(dataId, group, tenant, tag);
            ConfigRemoveResponse response = (ConfigRemoveResponse)this.requestProxy(this.getOneRunningClient(), request);
            return response.isSuccess();
        }

        public boolean isHealthServer() {
            try {
                return this.getOneRunningClient().isRunning();
            }
            catch (NacosException e) {
                LOGGER.warn("check server status failed. error={}", (Throwable)e);
                return false;
            }
        }
    }
}

