/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.ai;

import com.alibaba.nacos.api.ai.listener.AbstractNacosAgentCardListener;
import com.alibaba.nacos.api.ai.model.a2a.AgentCard;
import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentEndpoint;
import com.alibaba.nacos.api.exception.NacosException;

public interface A2aService {
    default public AgentCardDetailInfo getAgentCard(String agentName) throws NacosException {
        return this.getAgentCard(agentName, "");
    }

    default public AgentCardDetailInfo getAgentCard(String agentName, String version) throws NacosException {
        return this.getAgentCard(agentName, version, "");
    }

    public AgentCardDetailInfo getAgentCard(String var1, String var2, String var3) throws NacosException;

    default public void releaseAgentCard(AgentCard agentCard) throws NacosException {
        this.releaseAgentCard(agentCard, "SERVICE");
    }

    default public void releaseAgentCard(AgentCard agentCard, String registrationType) throws NacosException {
        this.releaseAgentCard(agentCard, registrationType, false);
    }

    public void releaseAgentCard(AgentCard var1, String var2, boolean var3) throws NacosException;

    default public void registerAgentEndpoint(String agentName, String version, String address, int port) throws NacosException {
        this.registerAgentEndpoint(agentName, version, address, port, "JSONRPC");
    }

    default public void registerAgentEndpoint(String agentName, String version, String address, int port, String transport) throws NacosException {
        this.registerAgentEndpoint(agentName, version, address, port, transport, "");
    }

    default public void registerAgentEndpoint(String agentName, String version, String address, int port, String transport, String path) throws NacosException {
        this.registerAgentEndpoint(agentName, version, address, port, transport, path, false);
    }

    default public void registerAgentEndpoint(String agentName, String version, String address, int port, String transport, String path, boolean supportTls) throws NacosException {
        AgentEndpoint agentEndpoint = new AgentEndpoint();
        agentEndpoint.setAddress(address);
        agentEndpoint.setPort(port);
        agentEndpoint.setTransport(transport);
        agentEndpoint.setPath(path);
        agentEndpoint.setSupportTls(supportTls);
        agentEndpoint.setVersion(version);
        this.registerAgentEndpoint(agentName, agentEndpoint);
    }

    public void registerAgentEndpoint(String var1, AgentEndpoint var2) throws NacosException;

    default public void deregisterAgentEndpoint(String agentName, String version, String address, int port) throws NacosException {
        AgentEndpoint agentEndpoint = new AgentEndpoint();
        agentEndpoint.setAddress(address);
        agentEndpoint.setPort(port);
        agentEndpoint.setVersion(version);
        this.deregisterAgentEndpoint(agentName, agentEndpoint);
    }

    public void deregisterAgentEndpoint(String var1, AgentEndpoint var2) throws NacosException;

    default public AgentCardDetailInfo subscribeAgentCard(String agentName, AbstractNacosAgentCardListener agentCardListener) throws NacosException {
        return this.subscribeAgentCard(agentName, "", agentCardListener);
    }

    public AgentCardDetailInfo subscribeAgentCard(String var1, String var2, AbstractNacosAgentCardListener var3) throws NacosException;

    default public void unsubscribeAgentCard(String agentName, AbstractNacosAgentCardListener agentCardListener) throws NacosException {
        this.unsubscribeAgentCard(agentName, "", agentCardListener);
    }

    public void unsubscribeAgentCard(String var1, String var2, AbstractNacosAgentCardListener var3) throws NacosException;
}

