/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.ai.cache;

import com.alibaba.nacos.api.ai.model.a2a.AgentCardDetailInfo;
import com.alibaba.nacos.api.ai.model.a2a.AgentInterface;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.ai.event.AgentCardChangedEvent;
import com.alibaba.nacos.client.ai.remote.AiGrpcClient;
import com.alibaba.nacos.client.ai.utils.CacheKeyUtils;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosAgentCardCacheHolder
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosAgentCardCacheHolder.class);
    private final AiGrpcClient aiGrpcClient;
    private final Map<String, AgentCardDetailInfo> agentCardCache;
    private final ScheduledExecutorService updaterExecutor;
    private final long updateIntervalMillis;
    private final Map<String, AgentCardUpdater> updateTaskMap;

    public NacosAgentCardCacheHolder(AiGrpcClient aiGrpcClient, NacosClientProperties properties) {
        this.aiGrpcClient = aiGrpcClient;
        this.agentCardCache = new ConcurrentHashMap<String, AgentCardDetailInfo>(4);
        this.updateTaskMap = new ConcurrentHashMap<String, AgentCardUpdater>(4);
        this.updaterExecutor = new ScheduledThreadPoolExecutor(1, new NameThreadFactory("com.alibaba.nacos.client.ai.agent.card.updater"));
        this.updateIntervalMillis = properties.getLong("nacosAiAgentCardCacheUpdateInterval", Long.valueOf(10000L));
    }

    public AgentCardDetailInfo getAgentCard(String agentName, String version) {
        String key = CacheKeyUtils.buildAgentCardKey(agentName, version);
        return this.agentCardCache.get(key);
    }

    public void processAgentCardDetailInfo(AgentCardDetailInfo detailInfo) {
        String agentName = detailInfo.getName();
        String version = detailInfo.getVersion();
        Boolean isLatest = detailInfo.isLatestVersion();
        String key = CacheKeyUtils.buildAgentCardKey(agentName, version);
        AgentCardDetailInfo oldAgentCard = this.agentCardCache.get(key);
        this.agentCardCache.put(key, detailInfo);
        if (null != isLatest && isLatest.booleanValue()) {
            String latestVersionKey = CacheKeyUtils.buildAgentCardKey(agentName, null);
            this.agentCardCache.put(latestVersionKey, detailInfo);
        }
        if (this.isAgentCardChanged(oldAgentCard, detailInfo)) {
            LOGGER.info("agent card {} changed, from {} -> {}.", new Object[]{detailInfo.getName(), JacksonUtils.toJson(oldAgentCard), JacksonUtils.toJson(detailInfo)});
            NotifyCenter.publishEvent(new AgentCardChangedEvent(detailInfo));
        }
    }

    public void addAgentCardUpdateTask(String agentName, String version) {
        String agentCardKey = CacheKeyUtils.buildAgentCardKey(agentName, version);
        this.updateTaskMap.computeIfAbsent(agentCardKey, s -> {
            AgentCardUpdater updateTask = new AgentCardUpdater(agentName, version);
            this.updaterExecutor.schedule(updateTask, this.updateIntervalMillis, TimeUnit.MILLISECONDS);
            return updateTask;
        });
    }

    public void removeAgentCardUpdateTask(String agentName, String version) {
        String agentNameKey = CacheKeyUtils.buildAgentCardKey(agentName, version);
        AgentCardUpdater updateTask = this.updateTaskMap.remove(agentNameKey);
        if (null != updateTask) {
            updateTask.cancel();
        }
    }

    private boolean isAgentCardChanged(AgentCardDetailInfo oldAgentCard, AgentCardDetailInfo newAgentCard) {
        if (null == oldAgentCard) {
            LOGGER.info("init new agent card: {} -> {}", (Object)newAgentCard.getName(), (Object)JacksonUtils.toJson(newAgentCard));
            return true;
        }
        if (!Objects.equals(oldAgentCard.getVersion(), newAgentCard.getVersion())) {
            return true;
        }
        List<AgentInterface> oldInterfaces = oldAgentCard.getAdditionalInterfaces();
        List<AgentInterface> newInterfaces = newAgentCard.getAdditionalInterfaces();
        if (Objects.isNull(oldInterfaces) && Objects.isNull(newInterfaces)) {
            return !Objects.equals(oldAgentCard.getUrl(), newAgentCard.getUrl());
        }
        if (this.anyOneIsNull(oldInterfaces, newInterfaces)) {
            return true;
        }
        return !CollectionUtils.isEqualCollection(oldInterfaces, newInterfaces);
    }

    private boolean anyOneIsNull(List<AgentInterface> oldAdditionalInterfaces, List<AgentInterface> newAdditionalInterfaces) {
        if (Objects.isNull(oldAdditionalInterfaces)) {
            return true;
        }
        return Objects.isNull(newAdditionalInterfaces);
    }

    @Override
    public void shutdown() throws NacosException {
        this.updaterExecutor.shutdownNow();
    }

    private class AgentCardUpdater
    implements Runnable {
        private final String agentName;
        private final String version;
        private final AtomicBoolean cancel;

        public AgentCardUpdater(String agentName, String version) {
            this.agentName = agentName;
            this.version = version;
            this.cancel = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            if (this.cancel.get()) {
                return;
            }
            try {
                AgentCardDetailInfo detailInfo = NacosAgentCardCacheHolder.this.aiGrpcClient.getAgentCard(this.agentName, this.version, "");
                NacosAgentCardCacheHolder.this.processAgentCardDetailInfo(detailInfo);
            }
            catch (Exception e) {
                NacosException nacosException;
                if (e instanceof NacosException && (nacosException = (NacosException)e).getErrCode() == 404) {
                    return;
                }
                LOGGER.warn("AgentCard updater execute query failed", (Throwable)e);
            }
            finally {
                if (!this.cancel.get()) {
                    NacosAgentCardCacheHolder.this.updaterExecutor.schedule(this, NacosAgentCardCacheHolder.this.updateIntervalMillis, TimeUnit.MILLISECONDS);
                }
            }
        }

        public void cancel() {
            this.cancel.set(true);
        }
    }
}

