/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel;

import com.alipay.easysdk.kernel.util.AntCertificationUtil;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CertEnvironment {
    private String rootCertContent;
    private String rootCertSN;
    private String merchantCertSN;
    private Map<String, String> cachedAlipayPublicKey = new ConcurrentHashMap<String, String>();

    public CertEnvironment(String merchantCertPath, String alipayCertPath, String alipayRootCertPath) {
        if (Strings.isNullOrEmpty(merchantCertPath) || Strings.isNullOrEmpty(alipayCertPath) || Strings.isNullOrEmpty(alipayCertPath)) {
            throw new RuntimeException("\u8bc1\u4e66\u53c2\u6570merchantCertPath\u3001alipayCertPath\u6216alipayRootCertPath\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002");
        }
        this.rootCertContent = AntCertificationUtil.readCertContent(alipayRootCertPath);
        this.rootCertSN = AntCertificationUtil.getRootCertSN(this.rootCertContent);
        this.merchantCertSN = AntCertificationUtil.getCertSN(AntCertificationUtil.readCertContent(merchantCertPath));
        String alipayPublicCertContent = AntCertificationUtil.readCertContent(alipayCertPath);
        this.cachedAlipayPublicKey.put(AntCertificationUtil.getCertSN(alipayPublicCertContent), AntCertificationUtil.getCertPublicKey(alipayPublicCertContent));
    }

    public String getRootCertSN() {
        return this.rootCertSN;
    }

    public String getMerchantCertSN() {
        return this.merchantCertSN;
    }

    public String getAlipayPublicKey(String sn) {
        if (Strings.isNullOrEmpty(sn)) {
            return this.cachedAlipayPublicKey.values().iterator().next();
        }
        if (this.cachedAlipayPublicKey.containsKey(sn)) {
            return this.cachedAlipayPublicKey.get(sn);
        }
        throw new RuntimeException("\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66[" + sn + "]\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6700\u65b0\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u5e76\u66ff\u6362\u539f\u8bc1\u4e66\u6587\u4ef6");
    }
}

