/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea;

import com.aliyun.tea.NameInMap;
import com.aliyun.tea.ValidateException;
import com.aliyun.tea.Validation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TeaModel {
    public Map<String, Object> toMap() throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : this.getClass().getFields()) {
            NameInMap anno = field.getAnnotation(NameInMap.class);
            String key = anno == null ? field.getName() : anno.value();
            if (null != field.get(this) && List.class.isAssignableFrom(field.get(this).getClass())) {
                ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
                Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
                Type listActualTypeArgument = listActualTypeArguments[0];
                Class itemType = null;
                if (listActualTypeArgument instanceof Class) {
                    itemType = (Class)listActualTypeArgument;
                }
                ArrayList arrayField = (ArrayList)field.get(this);
                ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < arrayField.size(); ++i) {
                    if (null != itemType && TeaModel.class.isAssignableFrom(itemType)) {
                        Map<String, Object> fields = ((TeaModel)arrayField.get(i)).toMap();
                        fieldList.add(fields);
                        continue;
                    }
                    fieldList.add((Map<String, Object>)arrayField.get(i));
                }
                map.put(key, fieldList);
                continue;
            }
            if (null != field.get(this) && TeaModel.class.isAssignableFrom(field.get(this).getClass())) {
                TeaModel teaModel = (TeaModel)field.get(this);
                map.put(key, teaModel.toMap());
                continue;
            }
            map.put(key, field.get(this));
        }
        return map;
    }

    public static <T extends TeaModel> T toModel(Map<String, ?> map, T model) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        for (Field field : model.getClass().getFields()) {
            NameInMap anno = field.getAnnotation(NameInMap.class);
            String key = anno == null ? field.getName() : anno.value();
            Object value = map.get(key);
            if (value == null) continue;
            value = TeaModel.parseNumber(value, field.getType());
            Class<?> clazz = field.getType();
            if (List.class.isAssignableFrom(clazz)) {
                Object teaModel;
                int i;
                ArrayList valueList = (ArrayList)value;
                ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
                Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
                Type listActualTypeArgument = listActualTypeArguments[0];
                Class itemType = null;
                if (listActualTypeArgument instanceof Class) {
                    itemType = (Class)listActualTypeArgument;
                }
                ArrayList result = new ArrayList();
                if (null != itemType && TeaModel.class.isAssignableFrom(itemType)) {
                    if (valueList.size() > 0 && Map.class.isAssignableFrom(valueList.get(0).getClass())) {
                        for (i = 0; i < valueList.size(); ++i) {
                            teaModel = TeaModel.toModel((Map)valueList.get(i), (TeaModel)itemType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            result.add(teaModel);
                        }
                    } else {
                        for (i = 0; i < valueList.size(); ++i) {
                            result.add(valueList.get(i));
                        }
                    }
                } else {
                    for (i = 0; i < valueList.size(); ++i) {
                        teaModel = valueList.get(i);
                        result.add(teaModel);
                    }
                }
                field.set(model, result);
                continue;
            }
            if (TeaModel.class.isAssignableFrom(clazz) && Map.class.isAssignableFrom(value.getClass())) {
                Object data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                field.set(model, TeaModel.toModel((Map)value, (TeaModel)data));
                continue;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                field.set(model, Integer.parseInt(String.valueOf(value)));
                continue;
            }
            if (Double.class.isAssignableFrom(clazz)) {
                field.set(model, Double.parseDouble(String.valueOf(value)));
                continue;
            }
            if (Long.class.isAssignableFrom(clazz)) {
                field.set(model, Long.parseLong(String.valueOf(value)));
                continue;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                field.set(model, Boolean.parseBoolean(String.valueOf(value)));
                continue;
            }
            field.set(model, value);
        }
        return model;
    }

    private static Object parseNumber(Object value, Class clazz) {
        if (value instanceof Double && (clazz == Long.class || clazz == Long.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValue();
        }
        if (value instanceof Double && (clazz == Integer.class || clazz == Integer.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValue();
        }
        return value;
    }

    public void validate() throws IllegalAccessException, ValidateException {
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object object = fields[i].get(this);
            Validation validation = fields[i].getAnnotation(Validation.class);
            boolean required = null != validation ? validation.required() : false;
            if (required && null == object) {
                throw new ValidateException("Field " + fields[i].getName() + " is required");
            }
            if (null == validation || null == object) continue;
            String pattern = validation.pattern();
            int maxLength = validation.maxLength();
            if ("".equals(pattern)) continue;
            this.determineType(fields[i].getType(), object, pattern, maxLength);
        }
    }

    private void determineType(Class clazz, Object object, String pattern, int maxLength) throws IllegalAccessException, ValidateException {
        boolean notException = true;
        if (Map.class.isAssignableFrom(clazz)) {
            this.validateMap(pattern, maxLength, (Map)object);
        } else if (TeaModel.class.isAssignableFrom(clazz)) {
            ((TeaModel)object).validate();
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            for (int j = 0; j < list.size(); ++j) {
                this.determineType(list.get(j).getClass(), list.get(j), pattern, maxLength);
            }
        } else if (clazz.isArray()) {
            Object[] objects = (Object[])object;
            for (int j = 0; j < objects.length; ++j) {
                this.determineType(clazz.getComponentType(), objects[j], pattern, maxLength);
            }
        } else {
            String value = String.valueOf(object);
            if (maxLength > 0) {
                boolean bl = notException = value.length() == maxLength;
            }
            if (notException) {
                notException = Pattern.matches(pattern, value);
            }
            if (!notException) {
                throw new ValidateException("param don't matched");
            }
        }
    }

    private void validateMap(String pattern, int maxLength, Map<String, Object> map) throws IllegalAccessException, ValidateException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            this.determineType(entry.getValue().getClass(), entry.getValue(), pattern, maxLength);
        }
    }

    public static Map<String, Object> buildMap(TeaModel teaModel) throws IllegalAccessException {
        if (null == teaModel) {
            return null;
        }
        return teaModel.toMap();
    }

    public static void validateParams(TeaModel teaModel, String paramName) throws ValidateException, IllegalAccessException {
        if (null == teaModel) {
            throw new ValidateException("parameter " + paramName + " is not allowed as null");
        }
        teaModel.validate();
    }

    public static Map<String, Object> toMap(Object object) throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != object && object instanceof Map) {
            return (Map)object;
        }
        if (null == object || !TeaModel.class.isAssignableFrom(object.getClass())) {
            return map;
        }
        for (Field field : object.getClass().getFields()) {
            String key = field.getName();
            if (null != field.get(object) && List.class.isAssignableFrom(field.get(object).getClass())) {
                ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
                Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
                Type listActualTypeArgument = listActualTypeArguments[0];
                Class itemType = null;
                if (listActualTypeArgument instanceof Class) {
                    itemType = (Class)listActualTypeArgument;
                }
                ArrayList arrayField = (ArrayList)field.get(object);
                ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < arrayField.size(); ++i) {
                    if (null != itemType && TeaModel.class.isAssignableFrom(itemType)) {
                        Map<String, Object> fields = TeaModel.toMap(arrayField.get(i));
                        fieldList.add(fields);
                        continue;
                    }
                    fieldList.add((Map<String, Object>)arrayField.get(i));
                }
                map.put(key, fieldList);
                continue;
            }
            if (null != field.get(object) && TeaModel.class.isAssignableFrom(field.get(object).getClass())) {
                map.put(key, TeaModel.toMap(field.get(object)));
                continue;
            }
            map.put(key, field.get(object));
        }
        return map;
    }

    public static <T extends TeaModel> T build(Map<String, ?> map, T model) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        for (Field field : model.getClass().getFields()) {
            String key = field.getName();
            Object value = map.get(key);
            if (value == null) continue;
            Class<?> clazz = field.getType();
            if (List.class.isAssignableFrom(clazz)) {
                Object teaModel;
                int i;
                ArrayList valueList = (ArrayList)value;
                ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
                Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
                Type listActualTypeArgument = listActualTypeArguments[0];
                Class itemType = null;
                if (listActualTypeArgument instanceof Class) {
                    itemType = (Class)listActualTypeArgument;
                }
                ArrayList result = new ArrayList();
                if (null != itemType && TeaModel.class.isAssignableFrom(itemType)) {
                    if (valueList.size() > 0 && Map.class.isAssignableFrom(valueList.get(0).getClass())) {
                        for (i = 0; i < valueList.size(); ++i) {
                            teaModel = TeaModel.build((Map)valueList.get(i), (TeaModel)itemType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            result.add(teaModel);
                        }
                    } else {
                        for (i = 0; i < valueList.size(); ++i) {
                            result.add(valueList.get(i));
                        }
                    }
                } else {
                    for (i = 0; i < valueList.size(); ++i) {
                        teaModel = valueList.get(i);
                        result.add(teaModel);
                    }
                }
                field.set(model, result);
                continue;
            }
            if (TeaModel.class.isAssignableFrom(clazz)) {
                Object data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                field.set(model, TeaModel.build(TeaModel.toMap(value), (TeaModel)data));
                continue;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                field.set(model, Integer.parseInt(String.valueOf(value)));
                continue;
            }
            if (Double.class.isAssignableFrom(clazz)) {
                field.set(model, Double.parseDouble(String.valueOf(value)));
                continue;
            }
            if (Long.class.isAssignableFrom(clazz)) {
                field.set(model, Long.parseLong(String.valueOf(value)));
                continue;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                field.set(model, Boolean.parseBoolean(String.valueOf(value)));
                continue;
            }
            field.set(model, value);
        }
        return model;
    }
}

