/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp;

import cn.beecp.BeeDataSourceConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp.BeeCpConfig;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeeCpUtils {
    private static final Logger log = LoggerFactory.getLogger(BeeCpUtils.class);

    public static BeeDataSourceConfig createConfig(BeeCpConfig g, BeeCpConfig item) {
        Field[] fields;
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        Class<BeeDataSourceConfig> configClazz = BeeDataSourceConfig.class;
        Class<BeeCpConfig> clazz = BeeCpConfig.class;
        for (Field f : fields = clazz.getDeclaredFields()) {
            try {
                String propertyName = f.getName();
                PropertyDescriptor pd = new PropertyDescriptor(propertyName, clazz);
                Method readMethod = pd.getReadMethod();
                Object value = readMethod.invoke((Object)item, new Object[0]);
                if (value == null) {
                    value = readMethod.invoke((Object)g, new Object[0]);
                }
                if (value == null) continue;
                try {
                    Method writeMethod = new PropertyDescriptor(propertyName, configClazz).getWriteMethod();
                    writeMethod.invoke((Object)config, value);
                }
                catch (IntrospectionException e1) {
                    log.warn("dynamic-datasource create beeCp get into trouble,your beeCp not support " + propertyName);
                }
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                log.warn("dynamic-datasource create beeCp get into trouble", (Throwable)e);
            }
        }
        return config;
    }

    private BeeCpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

