/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.spring;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.reflection.ForestArgumentsVariable;
import com.dtflys.forest.reflection.ForestMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SpringMethodVariableValue
implements ForestArgumentsVariable {
    private static final Object[] DEFAULT_ARGUMENTS = new Object[0];
    private final Object bean;
    private final Method method;

    public SpringMethodVariableValue(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public Object getValue(ForestRequest req, Object[] args) {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        try {
            if (paramTypes.length == 0) {
                return this.method.invoke(this.bean, DEFAULT_ARGUMENTS);
            }
            Object[] invokeArgs = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                if (ForestRequest.class.isAssignableFrom(paramType)) {
                    invokeArgs[i] = paramType.cast(req);
                    continue;
                }
                if (ForestMethod.class.isAssignableFrom(paramType)) {
                    invokeArgs[i] = req.getMethod();
                    continue;
                }
                if (ForestURL.class.isAssignableFrom(paramType)) {
                    invokeArgs[i] = req.url();
                    continue;
                }
                if (ForestBody.class.isAssignableFrom(paramType)) {
                    invokeArgs[i] = req.body();
                    continue;
                }
                throw new ForestRuntimeException("[Forest] Method '" + this.method.getName() + "' can not be binding to a Forest variable, because parameter type '" + paramType + "' is not supported.");
            }
            return this.method.invoke(this.bean, invokeArgs);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }
}

