package com.el.coordinator.boot.autoconfigure.fsm.configuration;

import com.el.coordinator.boot.fsm.config.*;
import com.el.coordinator.boot.fsm.config.child.ChildProcessor;
import com.el.coordinator.boot.fsm.config.validator.Validatable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.Collections;
import java.util.List;

/**
 * 文件服务自动化配置类.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-21
 */
@Configuration
@ConditionalOnProperty(prefix = "elitesland.base.service.file", name = "enable", havingValue = "true", matchIfMissing = true)
@ComponentScan(basePackages = {"com.el.coordinator.boot.fsm.controller", "com.el.coordinator.boot.fsm.service"})
@EnableConfigurationProperties(FileConfigProperties.class)
@Import({FileConfiguration.class, SwaggerConfigFsmBoot.class})
public class ElFsmAutoConfiguration<T> {

    @Bean
    @ConditionalOnMissingBean(ElFsmConfigurationCustomizer.class)
    public ElFsmConfigurationCustomizer<T> elFsmConfigurationCustomizer() {
        return new ElFsmConfigurationCustomizer<T>() {
            @Override
            public List<Validatable<T>> getValidators() {
                return Collections.emptyList();
            }

            @Override
            public List<ChildProcessor<T>> getChildProcessors() {
                return Collections.emptyList();
            }
        };
    }
}
