package com.el.coordinator.core.common.constant;

/**
 * fsm常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/31
 */
public class ConstantFsm {

    private ConstantFsm() {
    }

    /**
     * 删除标识：1-已删除，0-未删除
     */
    public static final int COMMON_DELETE_YES = 1;
    public static final int COMMON_DELETE_NO = 0;

    /**
     * 缓存Key
     * 模板配置
     */
    public static final String CACHE_KEY_TMPL_DETAIL = "el_fsm_tmpl_cfg";

    /**
     * 不限制
     */
    public static final int UN_LIMIT = -1;

    /**
     * 每个sheet行数限制最多100万
     * 实际是1048576，为了方便，定为100万
     */
    public static final int SHEET_ROW_MAX = 1000000;
}
