package com.el.coordinator.file.api;

import com.el.coordinator.core.common.api.ApiResult;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.el.coordinator.file.enums.FsmUploadAttributeEnum;
import com.el.coordinator.file.enums.FsmUploadTypeEnum;
import com.el.coordinator.file.parameter.CreatFileUploadInfoParam;
import com.el.coordinator.file.parameter.FileUploadInfoQueryParam;
import com.el.coordinator.file.parameter.StartFileUploadParam;
import com.el.coordinator.file.vo.CreatFileUploadInfoVO;
import com.el.coordinator.file.vo.FileUploadInfoVO;
import com.el.coordinator.file.vo.StartFileUploadVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;

/**
 * <p>
 * 文件管理服务的调用工具类
 * </p >
 *
 * @author niu.chen
 * @date 2021/2/13
 */
public class FsmApiRequestTest  {
    private String serviceUrl;
    private RestTemplate restTemplate;


    public static void main(String[]d) throws IOException {

        FsmApiRequestTest fsmApiRequestTest=new FsmApiRequestTest();
        ApiResult<CreatFileUploadInfoVO> creatFileUploadInfoVOApiResult=
                fsmApiRequestTest.applyFileUploadInfo();//上传第一阶段  申请

        ApiResult<StartFileUploadVO> startFileUploadVOApiResult=
                fsmApiRequestTest.startFileUpload(creatFileUploadInfoVOApiResult.getData().getFileCode()
        ,"D:\\Program Files\\nacos\\bin\\startup.sh");//第二阶段 上传文件

        ApiResult<PagingVO<FileUploadInfoVO>>  listApiResult=fsmApiRequestTest.search(startFileUploadVOApiResult.getData());

        String fileCode=listApiResult.getData().getRecords().get(0).getFileCode();

        ApiResult<FileUploadInfoVO>  fileUploadInfoVOApiResult=
                fsmApiRequestTest.findFileCodeOne(fileCode);

        System.out.println(fileUploadInfoVOApiResult);

        ApiResult<Integer>  deleteFileRes=  fsmApiRequestTest.deleteFile(fileCode);

        System.out.println(deleteFileRes);
    }


    /**阶段1上传 申请测试**/
    public  ApiResult<CreatFileUploadInfoVO> applyFileUploadInfo( ) {
        String serviceUri = "http://192.168.0.1:8888";//配置文件服务器地址
        serviceUri = FsmApiConstant.DEFAULT_FSM_SERVER_URI;//本地开发
        RestTemplate restTemplate = new RestTemplate();//可以选择用RestTemplate 连接池
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        CreatFileUploadInfoParam creatFileUploadInfoParam=new CreatFileUploadInfoParam();
        creatFileUploadInfoParam.setDocCode("DocCode");
        creatFileUploadInfoParam.setTenant("Tenant");
        creatFileUploadInfoParam.setProject("Project");
        creatFileUploadInfoParam.setBusiness("Business");
        creatFileUploadInfoParam.setAttribute(FsmUploadAttributeEnum.ACTIVITY);
        creatFileUploadInfoParam.setUploaderCode("test");
        creatFileUploadInfoParam.setGroupFlag("GroupFlag");
        creatFileUploadInfoParam.setType(FsmUploadTypeEnum.FILE);
//        creatFileUploadInfoParam.setOriginalFilename();
//        creatFileUploadInfoParam.setSize();
//        creatFileUploadInfoParam.setFileUrl2();
//        creatFileUploadInfoParam.setFileUrl3();

        ApiResult<CreatFileUploadInfoVO> creatFileUploadInfoVOApiResult=
                fsmApiRequest.applyFileUploadInfo(creatFileUploadInfoParam);

        System.out.println(creatFileUploadInfoVOApiResult);
        return creatFileUploadInfoVOApiResult;
    }

        /***阶段二测试  开始上传***/
    public ApiResult<StartFileUploadVO> startFileUpload(String filcode, String filePath) throws IOException {
        String serviceUri = "http://192.168.0.1:8888";//配置文件服务器地址
        serviceUri = FsmApiConstant.DEFAULT_FSM_SERVER_URI;//本地开发
        RestTemplate restTemplate = new RestTemplate();//可以选择用RestTemplate 连接池
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        StartFileUploadParam startFileUploadParam=new StartFileUploadParam();
        startFileUploadParam.setFileCode(filcode);
        startFileUploadParam.setFileToKen(filcode);

         Path path = Paths.get(filePath);
        File file = new File(path.toUri());
//        FileInputStream fileInputStream = new FileInputStream(file);
//        MultipartFile multipartFile = new MockMultipartFile(file.getName(),file.getName(),
//                MediaType.APPLICATION_OCTET_STREAM_VALUE, fileInputStream);

         FileItem fileItem = new DiskFileItem("mainFile",
                 Files.probeContentType(file.toPath()), false, file.getName(), (int) file.length(), file.getParentFile());


            InputStream input = new FileInputStream(file);
            OutputStream os = fileItem.getOutputStream();
            IOUtils.copy(input, os);
            // Or faster..
            // IOUtils.copy(new FileInputStream(file), fileItem.getOutputStream());


        MultipartFile multipartFile = new CommonsMultipartFile(fileItem);

        ApiResult<StartFileUploadVO>  startFileUploadVOApiResult=
                fsmApiRequest.startFileUploadFile(file,startFileUploadParam);

        System.out.println(startFileUploadVOApiResult);

        return  startFileUploadVOApiResult;
    }


     public ApiResult<PagingVO<FileUploadInfoVO>>   search(StartFileUploadVO startFileUploadVO) {
         String serviceUri = "http://192.168.0.1:8888";//配置文件服务器地址
         serviceUri = FsmApiConstant.DEFAULT_FSM_SERVER_URI;//本地开发
         RestTemplate restTemplate = new RestTemplate();//可以选择用RestTemplate 连接池
         FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
         FileUploadInfoQueryParam fileUploadInfoQueryParam =new FileUploadInfoQueryParam();
         fileUploadInfoQueryParam.setDocCode(startFileUploadVO.getDocCode());
         fileUploadInfoQueryParam.setTenant(startFileUploadVO.getTenant());
         fileUploadInfoQueryParam.setProject(startFileUploadVO.getProject());
         fileUploadInfoQueryParam.setBusiness(startFileUploadVO.getBusiness());
//          fileUploadInfoQueryParam.setFileCode(startFileUploadVO.getFileCode());

         ApiResult<PagingVO<FileUploadInfoVO>>  listApiResult=  fsmApiRequest.search(fileUploadInfoQueryParam);
         return listApiResult;
    }



    public ApiResult<FileUploadInfoVO> findFileCodeOne(String fileCode) {
        String serviceUri = "http://192.168.0.1:8888";//配置文件服务器地址
        serviceUri = FsmApiConstant.DEFAULT_FSM_SERVER_URI;//本地开发
        RestTemplate restTemplate = new RestTemplate();//可以选择用RestTemplate 连接池
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
      return  fsmApiRequest.findFileCodeOne(fileCode);
    }

    public ApiResult<Integer> deleteFile(String fileCode) {
        String serviceUri = "http://192.168.0.1:8888";//配置文件服务器地址
        serviceUri = FsmApiConstant.DEFAULT_FSM_SERVER_URI;//本地开发
        RestTemplate restTemplate = new RestTemplate();//可以选择用RestTemplate 连接池
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        return  fsmApiRequest.deleteFile(fileCode);
    }



}
