package com.el.coordinator.file.business.dto;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * 导入进度.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/5
 */
@Data
@Builder
public class ImportRateDTO implements Serializable {
    private static final long serialVersionUID = -862884510143913394L;

    public ImportRateDTO(Boolean finish, String tmplCode, Long total, Long count) {
        this.finish = finish;
        this.tmplCode = tmplCode;
        this.total = total;
        this.count = count;
    }

    public ImportRateDTO() {
    }

    /**
     * 是否导入完毕
     */
    private Boolean finish;

    /**
     * 导入模板编号
     */
    private String tmplCode;

    /**
     * 记录总数
     */
    private Long total;

    /**
     * 已导入数量
     */
    private Long count;
}
