package com.el.coordinator.file.business.enums;

/**
 * 存储类型.
 *
 * @author niuchen
 * @date 2021-05-26
 */
public enum StorageEnum {

    LOCALDISK("localDisk", "本地磁盘目录"),
    QINIU("qiniu", "七牛云对象存储"),
    ALIOSS("aliOss", "阿里云oos对象存储"),
    HWOBS("huaweiobs", "华为云obs对象存储"),
    MINIO("minio", "minio分布式存储"),
    TECENTCOS("tecentCos", "腾讯云对象存储");

    private final String code;
    private final String msg;

    StorageEnum(final String code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static StorageEnum get(String code) {
        StorageEnum[] ecs = StorageEnum.values();
        for (StorageEnum ec : ecs) {
            if (ec.getCode().equalsIgnoreCase(code)) {
                return ec;
            }
        }
        for (StorageEnum ec : ecs) {
            if (ec.name().equalsIgnoreCase(code)) {
                return ec;
            }
        }
        return null;
    }

    public static boolean exists(String code) {
        StorageEnum[] ecs = StorageEnum.values();
        for (StorageEnum ec : ecs) {
            if (ec.getCode().equalsIgnoreCase(code)) {
                return true;
            }
        }
        for (StorageEnum ec : ecs) {
            if (ec.name().equalsIgnoreCase(code)) {
                return true;
            }
        }
        return false;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
    }
