package com.el.coordinator.file.enums;

import com.el.coordinator.file.api.FsmApiConstant;

/**
 * @ProjectName: el-coordinator
 * @Package: com.el.coordinator.file.api
 * @ClassName: FsmApiConstantEnum
 * @Author: chen
 * @Description: 文件服务api接口地址枚举常量
 * @Date: 2021/2/11 19:04
 * @Version: 1.0
 */
public enum FsmApiConstantEnum {
    API_POST_UPLOAD( "文件上传",FsmApiConstant.API_POST_UPLOAD),
    API_GET_DOWNLOAD( " 文件下载",FsmApiConstant.API_GET_DOWNLOAD),
    API_POST_SEARCH( "文件信息检索",FsmApiConstant.API_POST_SEARCH),
    API_PUT_DELETE_FILE( "文件逻辑删除",FsmApiConstant.API_PUT_DELETE_FILE),
    API_POST_DELETEBATCH( "已上传文件批量删除",FsmApiConstant.API_POST_DELETEBATCH),
    API_PUT_ADDFILEBINDBUSINESS( "已上传文件信息复制",FsmApiConstant.API_PUT_ADDFILEBINDBUSINESS),
    API_PUT_UPDATE( "已上传文件修改",FsmApiConstant.API_PUT_UPDATE);

    private final String des;
    private final String url;

    FsmApiConstantEnum(final String des, final String url) {
        this.des = des;
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public String getDes() {
        return des;
    }

}