package com.el.coordinator.file.parameter;

import com.el.coordinator.core.common.jpa.param.QueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author shihao.ma
 * @since 2020/6/17
 */
@ApiModel("FileUploadInfoQueryParam[文件上传日志查询的入参]")
@Data
public class FileUploadInfoQueryParam<T> extends QueryParam implements Serializable {

    private static final long serialVersionUID = -345386902171320600L;

    @ApiModelProperty(value = "文件标识,由前端进行维护")
    private String docCode;

    @ApiModelProperty(value = "租户标识", required = true)
    private String tenant;

    @ApiModelProperty(value = "项目标识", required = true)
    private String project;

    @ApiModelProperty(value = "业务标识", required = true)
    private String business;

    @ApiModelProperty(value = "分组标识")
    private String groupFlag;

    @ApiModelProperty(value = "文件原名称")
    private String originalName;

    @ApiModelProperty(value = "后缀名")
    private String suffix;

    @ApiModelProperty(value = "文件编码")
    private List<String> fileCode;

    @ApiModelProperty("扩展自定义属性1")
    private String attribute;
    @ApiModelProperty("扩展自定义属性1")
    private String attribute1;
    @ApiModelProperty("扩展自定义属性2")
    private String attribute2;
    @ApiModelProperty("扩展自定义属性3")
    private String attribute3;
    @ApiModelProperty("扩展自定义属性4")
    private String attribute4;
    @ApiModelProperty("扩展自定义属性5")
    private String attribute5;

    /**
     * 扩展信息
     */
    private T extraInfo;
}
