package com.el.coordinator.file.service;


import com.el.coordinator.core.common.api.ApiResult;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.el.coordinator.file.parameter.CreatFileUploadInfoParam;
import com.el.coordinator.file.parameter.FilePackageParam;
import com.el.coordinator.file.parameter.FileUploadInfoQueryParam;
import com.el.coordinator.file.parameter.StartFileUploadParam;
import com.el.coordinator.file.vo.*;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.util.List;

/**
 * 文件模块服务接口
 *
 * @author shihao.ma
 * @since 2020/6/18
 */
public interface FileServiceApiInterface {


    /**
     * 文件上传信息创建 用于上传文件第一步. 先创建文件上传信息.
     * 给内部系统封装调用
     * 返回 文件code  上传token等信息
     */
    ApiResult<CreatFileUploadInfoVO> applyFileUploadInfo(CreatFileUploadInfoParam creatFileUploadInfoParam);

    /**
     * 两次文件上传  开始上传
     */
    ApiResult<StartFileUploadVO> startFileUploadFile(File file, StartFileUploadParam startFileUploadParam);

    /**
     * 两次文件上传  开始上传
     */
    ApiResult<StartFileUploadVO> startFileUploadResource(Resource resource, StartFileUploadParam startFileUploadParam);

    /**
     * 申请分片上传
     *
     * @param reqVO 文件信息
     * @return 上传记录标识
     */
    ApiResult<Long> applyChunk(@NotNull CreatFileUploadInfoParam reqVO);

    /**
     * 上传分片
     *
     * @param resource 文件
     * @param saveVO   分片信息
     * @return 上传结果
     */
    ApiResult<StartFileUploadVO> uploadChunk(@Nullable Resource resource, FileChunkSaveVO saveVO);

    /**
     * 文件删除
     */
    ApiResult<Integer> deleteFile(String fileCode);

    /**
     * 文件上传日志分页查询
     */
    ApiResult<PagingVO<FileUploadInfoVO>> search(FileUploadInfoQueryParam fileUploadInfoQueryParam);

    /**
     * 根据fileCode查询文件信息
     */
    ApiResult<FileUploadInfoVO> findFileCodeOne(String fileCode);

    /**
     * 判断文件是否存在
     *
     * @param fileCode 文件标识
     * @return 是否存在
     */
    ApiResult<Boolean> exsits(String fileCode);

    /**
     * 判断文件是否存在
     *
     * @param fileCodes 文件标识
     * @return 是否存在
     */
    ApiResult<Boolean> exsits(List<String> fileCodes);

    /**
     * 根据fileCode下载
     * <p>
     * 如果未找到子文件，则返回原文件
     *
     * @param fileCode  文件标识
     * @param childFlag 子文件标识
     * @return 下载结果
     */
    HttpEntity<Resource> download(String fileCode, String childFlag);

    /**
     * 根据fileCode下载
     * <p>
     * 适合大文件下载
     * 如果未找到子文件，则返回原文件
     *
     * @param fileCode  文件标识
     * @param childFlag 子文件标识
     * @return 下载结果
     */
    HttpEntity<StreamingResponseBody> downloadStreaming(String fileCode, String childFlag);

    /**
     * 打包下载
     *
     * @param param 下载参数
     * @return 文件流
     */
    ResponseEntity<StreamingResponseBody> downloadByPackage(FilePackageParam param);

    /**
     * 申请下载打包文件
     *
     * @param param 打包文件参数
     * @return 申请记录ID
     */
    ApiResult<Long> applyPackage(FilePackageParam param);

    /**
     * 查询打包结果
     *
     * @param applyId 申请记录ID
     * @return 打包结果
     */
    ApiResult<PackageResultVO> packageResult(@NotNull Long applyId);

    /**
     * 下载打包文件
     *
     * @param applyId     申请记录ID
     * @param packageName 下载名称
     * @return 文件流
     */
    ResponseEntity<StreamingResponseBody> downloadPackage(@NotNull Long applyId, String packageName);
}
