package com.el.coordinator.file.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求分片信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/11
 */
@Data
@ApiModel(description = "请求分片信息")
public class FileChunkReqVO implements Serializable {
    private static final long serialVersionUID = -1499275951127832703L;

    /**
     * 文件名称
     */
    @ApiModelProperty(value = "文件名称", position = 1, required = true)
    @NotBlank(message = "文件名称不能为空")
    private String filename;

    /**
     * 文件类型，mime-type
     */
    @ApiModelProperty(value = "文件类型", position = 2)
    private String mimeType;

    /**
     * 文件大小
     */
    @ApiModelProperty(value = "文件大小", position = 3, required = true)
    @NotNull(message = "文件大小为空")
    private Long size;
}
