package com.el.coordinator.file.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文件上传日志
 * extends BaseModelVO
 *
 * @author shihao.ma
 * @since 2020/6/17
 */
@Data
public class FileUploadInfoVO implements Serializable {

    private static final long serialVersionUID = -5142546837114942792L;

    private Long id;

    @ApiModelProperty(value = "文件编码")
    private String fileCode;

    @ApiModelProperty(value = "文件编码父编码")
    private String fileCodeParent;

    @ApiModelProperty(value = "上传者编码")
    private String uploaderCode;

    /**
     * 租户ID 租户ID
     */
    @ApiModelProperty("租户标识'")
    private String tenant;
    @ApiModelProperty(value = "文件编号标识")
    private String docCode;

    @ApiModelProperty(value = "项目标识")
    private String project;

    @ApiModelProperty(value = "业务标识")
    private String business;

    @ApiModelProperty(value = "日期标识")
    private String dateFlag;

    @ApiModelProperty(value = "分组标识")
    private String groupFlag;

    @ApiModelProperty(value = "子文件标识", position = 10)
    private String childFlag;

    @ApiModelProperty(value = "文件原名称")
    private String originalName;

    @ApiModelProperty(value = "上传类型 文件：file 图片：image 前端传入")
    private String type;

    @ApiModelProperty(value = "文件属性：1.动态文件 2.静态文件")
    private String attribute;

    @ApiModelProperty(value = "文件大小")
    private Long fileSize;

    @ApiModelProperty(value = "后缀名")
    private String suffix;


    @ApiModelProperty(value = "上传状态：0未删除 1.成功  -1失败")
    private int uploadStatus;

    @ApiModelProperty(value = "文件上传名称")
    private String uploadName;

    @ApiModelProperty(value = "文件目录")
    private String fileDirectoryPath;

    @ApiModelProperty(value = "文件地址")
    private String filePath;

    @ApiModelProperty(value = "上传时间")
    private LocalDateTime created;

    @ApiModelProperty(value = "web访问路径 静态文件地址")
    private String fileUrl;
    @ApiModelProperty(value = "web访问路径 静态文件地址2 业务系统设置使用")
    private String fileUrl2;
    @ApiModelProperty(value = "web访问路径 静态文件地址3 业务系统设置使用")
    private String fileUrl3;

    @ApiModelProperty(value = "外部可访问的完整链接")
    private String url;

    @ApiModelProperty(value = "动态文件路径-物理路径")
    private String downloadPath;
    @ApiModelProperty(value = "静态文件路径-物理路径")
    private String downloadPath2;

    @ApiModelProperty(value = "存储方式: 本地/FTP/云盘")
    private String storageType;

    @ApiModelProperty(value = "文件的内容类型 mime-type")
    private String mimeType;

    @ApiModelProperty("扩展自定义属性1")
    private String attribute1;
    @ApiModelProperty("扩展自定义属性2")
    private String attribute2;
    @ApiModelProperty("扩展自定义属性3")
    private String attribute3;
    @ApiModelProperty("扩展自定义属性4")
    private String attribute4;
    @ApiModelProperty("扩展自定义属性5")
    private String attribute5;

}
