package com.el.coordinator.file.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 打包下载结果.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/25
 */
@ApiModel(description = "打包下载结果")
@Data
public class PackageResultVO implements Serializable {
    private static final long serialVersionUID = -165843845417152552L;

    /**
     * 是否结束
     */
    @ApiModelProperty(value = "是否打包结束", position = 1)
    private Boolean finished;

    /**
     * 打包成功
     */
    @ApiModelProperty(value = "是否打包成功", position = 2)
    private Boolean success;

    /**
     * 失败信息
     */
    @ApiModelProperty(value = "失败信息", position = 3)
    private String msg;
}
