/*
 * Decompiled with CFR 0.152.
 */
package com.el.coordinator.file.api;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.core.common.api.ApiResult;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.el.coordinator.file.enums.FsmApiConstantEnum;
import com.el.coordinator.file.parameter.CreatFileUploadInfoParam;
import com.el.coordinator.file.parameter.FilePackageParam;
import com.el.coordinator.file.parameter.FileUploadInfoQueryParam;
import com.el.coordinator.file.parameter.StartFileUploadParam;
import com.el.coordinator.file.service.FileServiceApiInterface;
import com.el.coordinator.file.utils.ParserUtil;
import com.el.coordinator.file.vo.CreatFileUploadInfoVO;
import com.el.coordinator.file.vo.FileChunkSaveVO;
import com.el.coordinator.file.vo.FileUploadInfoVO;
import com.el.coordinator.file.vo.PackageResultVO;
import com.el.coordinator.file.vo.StartFileUploadVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public class FsmApiRequest
implements FileServiceApiInterface {
    private static final Logger log = LoggerFactory.getLogger(FsmApiRequest.class);
    private final String serviceUrl;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter formatterLong = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    public FsmApiRequest(String serviceUri, RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.serviceUrl = serviceUri;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public ApiResult<CreatFileUploadInfoVO> applyFileUploadInfo(CreatFileUploadInfoParam creatFileUploadInfoParam) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/applyFileUploadInfo";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)creatFileUploadInfoParam, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<CreatFileUploadInfoVO>>(){}, url, "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<StartFileUploadVO> startFileUploadFile(File file, StartFileUploadParam startFileUploadParam) {
        FileSystemResource resource = new FileSystemResource(file);
        return this.startFileUploadResource((Resource)resource, startFileUploadParam);
    }

    @Override
    public ApiResult<StartFileUploadVO> startFileUploadResource(Resource resource, StartFileUploadParam startFileUploadParam) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm" + FsmApiConstantEnum.API_POST_UPLOAD.getUrl();
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        requestEntity.add((Object)"fileCode", (Object)startFileUploadParam.getFileCode());
        requestEntity.add((Object)"fileToKen", (Object)startFileUploadParam.getFileToKen());
        requestEntity.add((Object)"file", (Object)resource);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)requestEntity, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<StartFileUploadVO>>(){}, url, "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<Long> applyChunk(CreatFileUploadInfoParam reqVO) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/apply/chunk";
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)reqVO, null), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<Long>>(){}, url, "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u7533\u8bf7\u5206\u7247\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<StartFileUploadVO> uploadChunk(@Nullable Resource file, FileChunkSaveVO saveVO) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/upload/chunk";
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        if (file != null) {
            requestEntity.add((Object)"file", (Object)file);
        }
        requestEntity.add((Object)"uploadId", (Object)saveVO.getUploadId());
        requestEntity.add((Object)"merge", (Object)Boolean.TRUE.equals(saveVO.getMerge()));
        if (saveVO.getPartNumber() != null) {
            requestEntity.add((Object)"partNumber", (Object)saveVO.getPartNumber());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "multipart/form-data");
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)requestEntity, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<StartFileUploadVO>>(){}, url, "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u4e0a\u4f20\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<Integer> deleteFile(String fileCode) {
        Object url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/deleteFile/{fileCode}";
        url = ParserUtil.parse1((String)url, fileCode);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        try {
            ResponseEntity result = this.restTemplate.exchange((String)url, HttpMethod.PUT, new HttpEntity(null, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<Integer>>(){}, (String)url, "\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38\uff1a{}", url, (Object)e);
            return ApiResult.fail((String)("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<PagingVO<FileUploadInfoVO>> search(FileUploadInfoQueryParam fileUploadInfoQueryParam) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/search";
        HttpHeaders headers = new HttpHeaders();
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)fileUploadInfoQueryParam, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<PagingVO<FileUploadInfoVO>>>(){}, url, "\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<FileUploadInfoVO> findFileCodeOne(String fileCode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.serviceUrl).append("/coordinator/el-fsm-service").append("/api/fsm").append("/getFileUploadInfoByFileCode/{fileCode}");
        String url = stringBuilder.toString();
        url = ParserUtil.parse1(url, fileCode);
        ParameterizedTypeReference<ApiResult<FileUploadInfoVO>> typeRef = new ParameterizedTypeReference<ApiResult<FileUploadInfoVO>>(){};
        HttpHeaders headers = new HttpHeaders();
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<FileUploadInfoVO>>(){}, url, "\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<Boolean> exsits(String fileCode) {
        Object url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/exists/{fileCode}";
        url = ParserUtil.parse1((String)url, fileCode);
        ParameterizedTypeReference<ApiResult<Boolean>> typeRef = new ParameterizedTypeReference<ApiResult<Boolean>>(){};
        HttpHeaders headers = new HttpHeaders();
        try {
            ResponseEntity result = this.restTemplate.exchange((String)url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<Boolean>>(){}, (String)url, "\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u5f02\u5e38\uff1a{}", url, (Object)e);
            return ApiResult.fail((String)("\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<Boolean> exsits(List<String> fileCodes) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/exists";
        ParameterizedTypeReference<ApiResult<Boolean>> typeRef = new ParameterizedTypeReference<ApiResult<Boolean>>(){};
        HttpHeaders headers = new HttpHeaders();
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(fileCodes, (MultiValueMap)headers), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<Boolean>>(){}, url, "\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public HttpEntity<Resource> download(String fileCode, String childFlag) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/download/{fileCode}?childFlag=" + (String)ObjectUtil.defaultIfNull((Object)childFlag, (Object)"");
        ResponseEntity entity = null;
        MediaType mediaType = null;
        int times = 1;
        while (true) {
            try {
                entity = this.restTemplate.exchange(url, HttpMethod.GET, null, byte[].class, new Object[]{fileCode, childFlag});
            }
            catch (RestClientException e) {
                log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)fileCode, (Object)e);
            }
            if (entity != null && entity.getStatusCode().is2xxSuccessful() && ArrayUtil.isNotEmpty((byte[])((byte[])entity.getBody()))) {
                mediaType = entity.getHeaders().getContentType();
                break;
            }
            if (times >= 3) break;
            ++times;
            try {
                TimeUnit.SECONDS.sleep(times);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (entity == null) {
            return ResponseEntity.badRequest().build();
        }
        if (ArrayUtil.isEmpty((byte[])((byte[])entity.getBody()))) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().contentType((MediaType)ObjectUtil.defaultIfNull((Object)mediaType, (Object)MediaType.APPLICATION_OCTET_STREAM)).body((Object)new ByteArrayResource((byte[])entity.getBody()));
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadStreaming(String fileCode, String childFlag) {
        FileUploadInfoVO infoVO = (FileUploadInfoVO)this.findFileCodeOne(fileCode).getData();
        for (int times = 1; infoVO == null && times < 5; ++times) {
            try {
                TimeUnit.SECONDS.sleep(times);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.findFileCodeOne(fileCode).getData();
        }
        if (infoVO == null) {
            return ResponseEntity.notFound().build();
        }
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(URLEncoder.encode(infoVO.getOriginalName(), StandardCharsets.UTF_8)).build();
        StreamingResponseBody responseBody = outputStream -> {
            this.writeStream(fileCode, childFlag, outputStream);
            outputStream.close();
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{contentDisposition.toString()})).body((Object)responseBody);
    }

    @Override
    public ResponseEntity<StreamingResponseBody> downloadByPackage(FilePackageParam param) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/package/download";
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)param);
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(URLEncoder.encode(CharSequenceUtil.blankToDefault((CharSequence)param.getPackageName(), (String)this.formatterLong.format(LocalDateTime.now())) + ".zip", StandardCharsets.UTF_8)).build();
        StreamingResponseBody responseBody = outputStream -> {
            ResponseExtractor responseExtractor = clientHttpResponse -> {
                if (clientHttpResponse.getStatusCode().is2xxSuccessful()) {
                    StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)outputStream);
                    return true;
                }
                return false;
            };
            Boolean result = (Boolean)this.restTemplate.execute(url, HttpMethod.POST, requestCallback, responseExtractor, new Object[0]);
            log.info("\u4e0b\u8f7d\u7ed3\u679c\uff1a{}\uff0c{}", (Object)url, (Object)result);
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(new MediaType("application", "zip")).header("Content-Disposition", new String[]{contentDisposition.toString()})).body((Object)responseBody);
    }

    @Override
    public ApiResult<Long> applyPackage(FilePackageParam param) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/package/apply";
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)param, null), String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<Long>>(){}, url, "\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<PackageResultVO> packageResult(Long applyId) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/package/result?applyId=" + applyId;
        try {
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
            return this.convertResult((ResponseEntity<String>)result, new TypeReference<ApiResult<PackageResultVO>>(){}, url, "\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u914d\u7f6e\u6b63\u5e38");
        }
        catch (Exception e) {
            log.error("\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
            return ApiResult.fail((String)("\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public ResponseEntity<StreamingResponseBody> downloadPackage(Long applyId, String packageName) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/package/apply/download?applyId=" + applyId;
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(URLEncoder.encode(CharSequenceUtil.blankToDefault((CharSequence)packageName, (String)this.formatterLong.format(LocalDateTime.now())) + ".zip", StandardCharsets.UTF_8)).build();
        StreamingResponseBody responseBody = outputStream -> {
            ResponseExtractor responseExtractor = clientHttpResponse -> {
                if (clientHttpResponse.getStatusCode().is2xxSuccessful()) {
                    StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)outputStream);
                    return true;
                }
                return false;
            };
            Boolean result = (Boolean)this.restTemplate.execute(url, HttpMethod.GET, null, responseExtractor, new Object[0]);
            log.info("\u6253\u5305\u4e0b\u8f7d\u7ed3\u679c\uff1a{}\uff0c{}", (Object)url, (Object)result);
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(new MediaType("application", "zip")).header("Content-Disposition", new String[]{contentDisposition.toString()})).body((Object)responseBody);
    }

    private <T> T convertResult(ResponseEntity<String> resp, TypeReference<T> resultTypeRef, String url, String failMsg) throws JsonProcessingException {
        if (resp.getStatusCode().is2xxSuccessful() && resp.getBody() != null) {
            return (T)this.objectMapper.readValue((String)resp.getBody(), resultTypeRef);
        }
        log.error("\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff1a{}\uff0c {}, {}", new Object[]{url, resp.getStatusCodeValue(), resp.getBody()});
        return (T)ApiResult.fail((String)failMsg);
    }

    private void writeStream(String fileCode, String childFlag, OutputStream outputStream) {
        String url = this.serviceUrl + "/coordinator/el-fsm-service/api/fsm/download/{fileCode}?childFlag=" + (String)ObjectUtil.defaultIfNull((Object)childFlag, (Object)"");
        RequestCallback requestCallback = request -> request.getHeaders().setAccept(List.of(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
        ResponseExtractor responseExtractor = clientHttpResponse -> {
            if (clientHttpResponse.getStatusCode().is2xxSuccessful()) {
                StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)outputStream);
                return true;
            }
            return false;
        };
        Boolean result = false;
        int times = 1;
        while (true) {
            try {
                result = (Boolean)this.restTemplate.execute(url, HttpMethod.GET, requestCallback, responseExtractor, new Object[]{fileCode});
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            }
            if (BooleanUtil.isTrue((Boolean)result) || times >= 3) break;
            ++times;
            try {
                TimeUnit.SECONDS.sleep(times);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

