/*
 * Decompiled with CFR 0.152.
 */
package com.el.coordinator.file.api;

import com.el.coordinator.core.common.api.ApiResult;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.el.coordinator.file.api.FsmApiRequest;
import com.el.coordinator.file.enums.FsmUploadAttributeEnum;
import com.el.coordinator.file.enums.FsmUploadTypeEnum;
import com.el.coordinator.file.parameter.CreatFileUploadInfoParam;
import com.el.coordinator.file.parameter.FileUploadInfoQueryParam;
import com.el.coordinator.file.parameter.StartFileUploadParam;
import com.el.coordinator.file.vo.CreatFileUploadInfoVO;
import com.el.coordinator.file.vo.FileUploadInfoVO;
import com.el.coordinator.file.vo.StartFileUploadVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FsmApiRequestTest {
    private String serviceUrl;
    private RestTemplate restTemplate;

    public static void main(String[] d) throws IOException {
        FsmApiRequestTest fsmApiRequestTest = new FsmApiRequestTest();
        ApiResult<CreatFileUploadInfoVO> creatFileUploadInfoVOApiResult = fsmApiRequestTest.applyFileUploadInfo();
        ApiResult<StartFileUploadVO> startFileUploadVOApiResult = fsmApiRequestTest.startFileUpload(((CreatFileUploadInfoVO)creatFileUploadInfoVOApiResult.getData()).getFileCode(), "D:\\Program Files\\nacos\\bin\\startup.sh");
        ApiResult<PagingVO<FileUploadInfoVO>> listApiResult = fsmApiRequestTest.search((StartFileUploadVO)startFileUploadVOApiResult.getData());
        String fileCode = ((FileUploadInfoVO)((PagingVO)listApiResult.getData()).getRecords().get(0)).getFileCode();
        ApiResult<FileUploadInfoVO> fileUploadInfoVOApiResult = fsmApiRequestTest.findFileCodeOne(fileCode);
        System.out.println(fileUploadInfoVOApiResult);
        ApiResult<Integer> deleteFileRes = fsmApiRequestTest.deleteFile(fileCode);
        System.out.println(deleteFileRes);
    }

    public ApiResult<CreatFileUploadInfoVO> applyFileUploadInfo() {
        String serviceUri = "http://192.168.0.1:8888";
        serviceUri = "http://127.0.0.1:7877";
        RestTemplate restTemplate = new RestTemplate();
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        CreatFileUploadInfoParam creatFileUploadInfoParam = new CreatFileUploadInfoParam();
        creatFileUploadInfoParam.setDocCode("DocCode");
        creatFileUploadInfoParam.setTenant("Tenant");
        creatFileUploadInfoParam.setProject("Project");
        creatFileUploadInfoParam.setBusiness("Business");
        creatFileUploadInfoParam.setAttribute(FsmUploadAttributeEnum.ACTIVITY);
        creatFileUploadInfoParam.setUploaderCode("test");
        creatFileUploadInfoParam.setGroupFlag("GroupFlag");
        creatFileUploadInfoParam.setType(FsmUploadTypeEnum.FILE);
        ApiResult<CreatFileUploadInfoVO> creatFileUploadInfoVOApiResult = fsmApiRequest.applyFileUploadInfo(creatFileUploadInfoParam);
        System.out.println(creatFileUploadInfoVOApiResult);
        return creatFileUploadInfoVOApiResult;
    }

    public ApiResult<StartFileUploadVO> startFileUpload(String filcode, String filePath) throws IOException {
        String serviceUri = "http://192.168.0.1:8888";
        serviceUri = "http://127.0.0.1:7877";
        RestTemplate restTemplate = new RestTemplate();
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        StartFileUploadParam startFileUploadParam = new StartFileUploadParam();
        startFileUploadParam.setFileCode(filcode);
        startFileUploadParam.setFileToKen(filcode);
        Path path = Paths.get(filePath, new String[0]);
        File file = new File(path.toUri());
        DiskFileItem fileItem = new DiskFileItem("mainFile", Files.probeContentType(file.toPath()), false, file.getName(), (int)file.length(), file.getParentFile());
        FileInputStream input = new FileInputStream(file);
        OutputStream os = fileItem.getOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)os);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile((FileItem)fileItem);
        ApiResult<StartFileUploadVO> startFileUploadVOApiResult = fsmApiRequest.startFileUploadFile(file, startFileUploadParam);
        System.out.println(startFileUploadVOApiResult);
        return startFileUploadVOApiResult;
    }

    public ApiResult<PagingVO<FileUploadInfoVO>> search(StartFileUploadVO startFileUploadVO) {
        String serviceUri = "http://192.168.0.1:8888";
        serviceUri = "http://127.0.0.1:7877";
        RestTemplate restTemplate = new RestTemplate();
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        FileUploadInfoQueryParam fileUploadInfoQueryParam = new FileUploadInfoQueryParam();
        fileUploadInfoQueryParam.setDocCode(startFileUploadVO.getDocCode());
        fileUploadInfoQueryParam.setTenant(startFileUploadVO.getTenant());
        fileUploadInfoQueryParam.setProject(startFileUploadVO.getProject());
        fileUploadInfoQueryParam.setBusiness(startFileUploadVO.getBusiness());
        ApiResult<PagingVO<FileUploadInfoVO>> listApiResult = fsmApiRequest.search(fileUploadInfoQueryParam);
        return listApiResult;
    }

    public ApiResult<FileUploadInfoVO> findFileCodeOne(String fileCode) {
        String serviceUri = "http://192.168.0.1:8888";
        serviceUri = "http://127.0.0.1:7877";
        RestTemplate restTemplate = new RestTemplate();
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        return fsmApiRequest.findFileCodeOne(fileCode);
    }

    public ApiResult<Integer> deleteFile(String fileCode) {
        String serviceUri = "http://192.168.0.1:8888";
        serviceUri = "http://127.0.0.1:7877";
        RestTemplate restTemplate = new RestTemplate();
        FsmApiRequest fsmApiRequest = new FsmApiRequest(serviceUri, restTemplate, new ObjectMapper());
        return fsmApiRequest.deleteFile(fileCode);
    }
}

