/*
 * Decompiled with CFR 0.152.
 */
package com.el.coordinator.file.utils;

import java.text.MessageFormat;

public class ParserUtil {
    public static String parse(String openToken, String closeToken, String text, Object ... args) {
        if (args == null || args.length <= 0) {
            return text;
        }
        int argsIndex = 0;
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String value = argsIndex <= args.length - 1 ? (args[argsIndex] == null ? "" : args[argsIndex].toString()) : expression.toString();
                    builder.append(value);
                    offset = end + closeToken.length();
                    ++argsIndex;
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String parse0(String text, Object ... args) {
        return ParserUtil.parse("${", "}", text, args);
    }

    public static String parse1(String text, Object ... args) {
        return ParserUtil.parse("{", "}", text, args);
    }

    public static void main(String ... args) {
        System.out.println(ParserUtil.parse("{", "}", "\u6211\u7684\u540d\u5b57\u662f\\{},\u7ed3\u679c\u662f{}\uff0c\u53ef\u4fe1\u5ea6\u662f%{}", "\u96f7\u950b", true, 100));
        System.out.println(ParserUtil.parse0("\u6211\u7684\u540d\u5b57\u662f${},\u7ed3\u679c\u662f${}\uff0c\u53ef\u4fe1\u5ea6\u662f%${}", "\u96f7\u950b", true, 100));
        System.out.println(ParserUtil.parse1("\u6211\u7684\u540d\u5b57\u662f{},\u7ed3\u679c\u662f{}\uff0c\u53ef\u4fe1\u5ea6\u662f%{}", "\u96f7\u950b", true, 100));
        String sv = MessageFormat.format("/user/psth/{0}/sdfsdf/", "123333");
        System.out.println(sv);
        sv = MessageFormat.format("/user/psth/{0}/sdfsdf/{1}", "123333", "555");
        System.out.println(sv);
        sv = MessageFormat.format("/user/psth/{0}/sdfsdf", "123333", "123123");
        System.out.println(sv);
        sv = MessageFormat.format("/user/psth/{0}/sdfsdf", null);
        System.out.println(sv);
    }
}

