package com.el.coordinator.feign;


import com.el.coordinator.core.common.api.ApiResult;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.el.coordinator.file.api.FsmApiConstant;
import com.el.coordinator.file.parameter.FileUploadInfoQueryParam;
import com.el.coordinator.file.parameter.StartFileUploadParam;
import com.el.coordinator.file.vo.FileUploadInfoVO;
import com.el.coordinator.file.vo.StartFileUploadVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * feign客户端接口
 * </p >
 *
 * @author niu.chen
 * @date 2021-03-25
 */
@FeignClient(name = "el-fsm-service")
public interface FileFeignInterface {

    String uri=FsmApiConstant.DEFAULT_FSM_CONTEXT_PATH+ FsmApiConstant.DEFAULT_FSM_SERVICE_API;
    @PostMapping( uri+FsmApiConstant.API_POST_UPLOAD)
    ApiResult<StartFileUploadVO> startFileUpload(StartFileUploadParam startFileUploadParam, @RequestParam MultipartFile file);

    @ApiOperation("上传文件信息查询 根据fileCode")
    @GetMapping(uri+ FsmApiConstant.API_GET_File_CODE)
    ApiResult<FileUploadInfoVO> getFileUploadInfoByFileCode(@PathVariable(value = "fileCode") String fileCode );

    @ApiOperation("上传文件信息检索接口")
    @RequestMapping(value =uri+ FsmApiConstant.API_POST_SEARCH, method = RequestMethod.POST)
    ApiResult<PagingVO<FileUploadInfoVO>> listFileUploadInfoAll(@RequestBody FileUploadInfoQueryParam fileUploadInfoQueryParam);
//    @PostMapping("/account/insert")
//    ResultData<String> insert(@RequestBody AccountDTO accountDTO);
//
//    @PostMapping("/account/delete")
//    ResultData<String> delete(@RequestParam("accountCode") String accountCode);
//
//    @PostMapping("/account/update")
//    ResultData<String> update(@RequestBody AccountDTO accountDTO);
//
//    @GetMapping("/account/getByCode/{accountCode}")
//    ResultData<AccountDTO> getByCode(@PathVariable(value = "accountCode") String accountCode);

}
