package com.el.coordinator.file.api;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * @date 2021/2/11
 */
public class FsmApiConstant {

    /*****默认配置*****/
    //服务名称
    public final static String DEFAULT_SERVICE_NAME = "el-fsm-service";
    //默认项目域IP
    public final static String DEFAULT_FSM_SERVER_IP = "127.0.0.1";
    //默认项目RUL
    public final static String DEFAULT_FSM_SERVER_PORT = "7877";
    //默认项目域URL
    public final static String DEFAULT_FSM_SERVER_URI = "http://" + DEFAULT_FSM_SERVER_IP + ":" + DEFAULT_FSM_SERVER_PORT;
    //默认项目路径
    public final static String DEFAULT_FSM_CONTEXT_PATH = "/coordinator/el-fsm-service";
    //默认项目URL
    public final static String DEFAULT_FSM_CONTEXT_URL = DEFAULT_FSM_SERVER_URI + DEFAULT_FSM_CONTEXT_PATH;

    //消息服务controller API前路径**/
    public final static String DEFAULT_FSM_SERVICE_API = "/api/fsm";

    public final static String DEFAULT_FSM_TEST_SERVICE_API = "/api/fsm/test";
    /*****默认配置 end*****/


    /***文件上传**/

    public final static String API_POST_UPLOAD_APPLY = "/applyFileUploadInfo";
    public final static String API_POST_UPLOAD = "/upload";
    /***
     * 文件下载
     *  /download/{fileCode}  RequestMethod.GET
     * **/
    public final static String API_GET_DOWNLOAD = "/download/{fileCode}";
    /***
     * 图片下载
     *   /preview/{fileCode} RequestMethod.GET
     * **/
    public final static String API_GET_PREVIEW = "/preview/{fileCode}";

    /***文件信息检索**/
    public final static String API_POST_SEARCH = "/search";

    /***文件信息查询 根据fileCode**/
    public final static String API_GET_File_CODE = "/getFileUploadInfoByFileCode/{fileCode}";

    /**
     * 判断文件是否存在
     */
    public final static String API_GET_FILE_EXISTS = "/exists/{fileCode}";

    /**
     *
     * 文件是否存在
     */
    public final static String API_POST_FILE_EXISTS = "/exists";

    /**
     * 打包下载
     */
    public static final String API_PACKAGE_DOWNLOAD = "/package/download";
    /**
     * 申请打包下载
     */
    public static final String API_PACKAGE_APPLY = "/package/apply";
    /**
     * 打包下载是否结束
     */
    public static final String API_PACKAGE_FINISHED = "/package/result";
    /**
     * 下载打包文件
     */
    public static final String API_PACKAGE_APPLY_DOWNLOAD = "/package/apply/download";

    /***
     *  文件逻辑删除
     *   /deleteFile/{fileCode}  PUT
     * **/
    public final static String API_PUT_DELETE_FILE = "/deleteFile/{fileCode}";

    /***
     *  已上传文件批量删除
     *    /deleteBatch
     * **/
    public final static String API_POST_DELETEBATCH = "/deleteBatch";

    /***
     *  已上传文件修改
     *    "/update", method = RequestMethod.PUT
     * **/
    public final static String API_PUT_UPDATE = "/update";

    /***
     *  已上传文件信息复制
     *     value = "/addFileBindBusiness", method = RequestMethod.PUT
     * **/
    public final static String API_PUT_ADDFILEBINDBUSINESS = "/addFileBindBusiness";

    /**
     * 申请分片上传
     */
    public final static String API_CHUNK_APPLY = "/apply/chunk";

    /**
     * 上传分片
     */
    public final static String API_CHUNK_UPLOAD = "/upload/chunk";

    /**
     * 模板下载路径
     */
    public static final String API_TMPL_DOWNLOAD = "/api/tmpl/{code}/download";

    /**
     * 模板信息路径
     */
    public static final String API_TMPL_INFO = "/api/tmpl/byCode/{code}";

    /**
     * 保存导入记录
     */
    public static final String API_TMPL_IMPORT_RECORD_SAVE = "/api/tmpl/{code}/record";

    /**
     * 更新导入记录
     */
    public static final String API_TMPL_IMPORT_TOTAL = "/api/tmpl/{importId}/numTotal?numTotal={numTotal}";

    /**
     * 更新导入记录
     */
    public static final String API_TMPL_IMPORT_RESULT = "/api/tmpl/record/{importId}/result";

    /**
     * 获取导入进度
     */
    public static final String API_TMPL_IMPORT_RATE = "/api/tmpl/record/{importId}/importRate";

    /**
     * 获取记录的文件标识
     */
    public static final String API_TMPL_RECORD_FILE_CODE = "/api/tmpl/record/{importId}/fileCode";

    /**
     * 获取未导入结束的记录ID
     */
    public static final String API_TMPL_IMPORT_UNFINISHED_ID = "/api/tmpl/import/unfinished";

    /**
     * 保存导出文件
     */
    public static final String API_TMPL_EXPORT_FILE = "/api/tmpl/export/{importId}/file?fileCode={fileCode}&order={order}";
}

