package com.el.coordinator.file.api;

import com.el.coordinator.core.common.api.ApiResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * <p>
 * FSM请求工具类
 * </p >
 *
 * @author niu.chen
 * @date 2021/2/24
 */
public class FsmApiRequestUtil<T, R> {


    /***
     * 文件服务API默认调用方法示例
     * @param serviceUrl 服务器url
     * @param method 调用方法 FsmApiConstant中有
     * @param requestEntity  方法参数
     * **/
    public   ApiResult apiPostExecute(RestTemplate restTemplate, String serviceUrl, String method, MultiValueMap<String, Object> requestEntity  ) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serviceUrl)
                .append(FsmApiConstant.DEFAULT_FSM_CONTEXT_PATH)
                .append(FsmApiConstant.DEFAULT_FSM_SERVICE_API)
                .append(method);
        String url = stringBuilder.toString();
        ResponseEntity<? extends ApiResult> responseEntity = null;

        responseEntity = restTemplate.postForEntity(url, requestEntity, new ApiResult<R>().getClass());

        if (responseEntity == null || responseEntity.getStatusCode() != HttpStatus.OK) {
            return ApiResult.fail();
        }

        ApiResult body = responseEntity.getBody();
        return body;
    }


//    /***
//     * 文件服务API默认调用方法示例
//     * @param serviceUrl 服务器url
//     * @param method 调用方法 FsmApiConstant中有
//     * @param param  方法参数
//     * **/
//    public ApiResult apiGetExecute(String serviceUrl, String method, T param) {
//        RestTemplate restTemplate = new RestTemplate();
//        StringBuilder stringBuilder = new StringBuilder();
//        stringBuilder.append(serviceUrl)
//                .append(FsmApiConstant.DEFAULT_FSM_CONTEXT_PATH)
//                .append(FsmApiConstant.DEFAULT_FSM_SERVICE_API)
//                .append(method);
//        String url = stringBuilder.toString();
//        ResponseEntity<? extends ApiResult> responseEntity = null;
//
//        responseEntity = restTemplate.getForEntity(url, new ApiResult<R>().getClass(), param);
//
//        if (responseEntity == null || responseEntity.getStatusCode() != HttpStatus.OK) {
//            return ApiResult.fail();
//        }
//
//        ApiResult body = responseEntity.getBody();
//        return body;
//    }
}
