package com.el.coordinator.file.business.vo;

import com.el.coordinator.file.business.enums.FileTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@ApiModel(description = "文件信息返回对象")
@Data
public class FileObjRespVO<T> implements Serializable {

    @ApiModelProperty(value = "文件编码，文件服务器上的文件唯一标识", position = 1)
    private String fileCode;

    @ApiModelProperty(value = "文件原名称", position = 2)
    private String originalName;

    @ApiModelProperty(value = "文件大小，字节B", position = 3)
    private Long fileSize;

    @ApiModelProperty(value = "文件名后缀", position = 4)
    private String suffix;

    @ApiModelProperty(value = "文件内容类型，mime-type", position = 5)
    private String mimeType;

    @ApiModelProperty(value = "常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见", position = 10)
    private FileTypeEnum fileType;

    @ApiModelProperty(value = "上传时间", position = 11)
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "宽度，图片时有值", position = 20)
    private Integer width;

    @ApiModelProperty(value = "高度，图片时有值", position = 21)
    private Integer height;

    @ApiModelProperty(value = "文件预览url", position = 30)
    private String urlPreview;

    @ApiModelProperty(value = "文件下载url", position = 31)
    private String urlDownload;

    @ApiModelProperty(value = "文件删除url", position = 32)
    private String urlDelete;

    @ApiModelProperty(value = "完整的外部可访问链接", position = 33)
    private String url;

    @ApiModelProperty(value = "扩展参数", position = 40)
    private T extraInfo;
}
