package com.el.coordinator.file.parameter;

import com.el.coordinator.file.enums.FsmUploadAttributeEnum;
import com.el.coordinator.file.enums.FsmUploadTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author 牛琛
 * @since 2021/2/17
 */
@ApiModel("CreatFileUploadInfoParam[文件上传第一段入参]")
@Data
public class CreatFileUploadInfoParam<T> implements Serializable {

    private static final long serialVersionUID = 131518464150036712L;

    @ApiModelProperty(value = "文件标识,由前端进行维护", position = 1)
    private String docCode;

    @ApiModelProperty(value = "租户标识-影响目录", required = true, position = 2)
    @NotBlank
    private String tenant;

    @ApiModelProperty(value = "项目标识-影响目录", required = true, position = 3)
    @NotBlank
    private String project;

    @ApiModelProperty(value = "业务标识-影响目录", required = true, position = 4)
    @NotBlank
    private String business;

    @NotNull
    @ApiModelProperty(value = "上传动静属性-影响目录", required = true, position = 6)
    private FsmUploadAttributeEnum attribute;

    @ApiModelProperty(value = "上传人编码", position = 5)
    @NotBlank
    private String uploaderCode;


    @ApiModelProperty(value = "分组标识", position = 7)
    private String groupFlag;

    @ApiModelProperty(value = "上传类型 文件：file 图片：image 由前端维护", required = true, position = 8)
    private FsmUploadTypeEnum type;

    @ApiModelProperty(value = "父文件的文件标识", position = 9)
    private String parentFileCode;

    @ApiModelProperty(value = "子文件标识，当parentFireCode不空时必填", position = 10)
    private String childFlag;

    @ApiModelProperty(value = "文件原始名称")
    private String originalFilename;

    @ApiModelProperty(value = "文件的mime-type")
    private String mimeType;

    @ApiModelProperty(value = "文件大小")
    private Long size;

    @ApiModelProperty(value = "web访问路径 静态文件地址2 业务系统设置使用 如:nginx代理地址")
    private String fileUrl2;
    @ApiModelProperty(value = "web访问路径 静态文件地址3 业务系统设置使用 如:cdn地址")
    private String fileUrl3;


    @ApiModelProperty("扩展自定义属性1")
    private String attribute1;
    @ApiModelProperty("扩展自定义属性2")
    private String attribute2;
    @ApiModelProperty("扩展自定义属性3")
    private String attribute3;
    @ApiModelProperty("扩展自定义属性4")
    private String attribute4;
    @ApiModelProperty("扩展自定义属性5")
    private String attribute5;


    /**
     * 扩展信息
     */
    private T extraInfo;
}
