package com.el.coordinator.file.parameter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 文件打包参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/24
 */
@Data
@ApiModel(description = "打包文件信息")
public class FilePackageParam implements Serializable {
    private static final long serialVersionUID = 3488886314340528026L;

    @ApiModelProperty(value = "打包名称", position = 1)
    private String packageName;

    /**
     * 打包文件
     */
    @ApiModelProperty(value = "打包文件", position = 2)
    @NotEmpty(message = "打包文件为空")
    private List<PackageEntryParam> fileList;

}
