package com.el.coordinator.file.parameter;

import com.el.coordinator.file.enums.FsmUploadAttributeEnum;
import com.el.coordinator.file.enums.FsmUploadTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.InputStream;
import java.io.Serializable;

/**
 * @author shihao.ma
 * @since 2020/6/17
 */
@ApiModel("FileUploadParam[文件上传的入参]")
@Data
public class FileUploadParam implements Serializable {

    private static final long serialVersionUID = 131518464150036712L;

    @ApiModelProperty(value = "文件标识,由前端进行维护")
    private String docCode;

    @ApiModelProperty(value = "租户标识-影响目录", required = true)
    @NotEmpty
    private String tenant;

    @ApiModelProperty(value = "项目标识-影响目录", required = true)
    @NotEmpty
    private String project;

    @ApiModelProperty(value = "业务标识-影响目录", required = true)
    @NotEmpty
    private String business;
    @ApiModelProperty(value = "上传人编码-影响目录", required = true)
    @NotEmpty
    private String uploaderCode;

    @NotEmpty
    @ApiModelProperty("上传动静属性-影响目录")
    private FsmUploadAttributeEnum attribute;

    @ApiModelProperty(value = "分组标识", required = true)
    private String  groupFlag;

    @ApiModelProperty(value = "上传类型 文件：file 图片：image 由前端维护")
    private FsmUploadTypeEnum type;

     //    @ApiModelProperty(value = "文件的输入流")
//    private InputStream inputStream;

    @ApiModelProperty(value = "文件原始名称")
    @NotEmpty
    private String originalFilename;

    @ApiModelProperty(value = "文件大小")
    private Long size;
//    @ApiModelProperty("批量上传同批次号")
//    private String group;



//    private InputStream inputStream;


}
