package com.el.coordinator.file.parameter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 打包的文件信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/25
 */
@Data
@ApiModel(description = "打包的文件信息")
public class PackageEntryParam implements Serializable {
    private static final long serialVersionUID = 9085928620571202743L;

    /**
     * 文件编码
     */
    @ApiModelProperty(value = "文件编码", position = 1)
    @NotBlank(message = "文件编码为空")
    private String fileCode;

    /**
     * 文件目录列表
     */
    @ApiModelProperty(value = "文件目录列表", position = 2)
    private List<String> fileDirectories;

    /**
     * 文件名称
     * <p>
     * 为空则使用原有名称
     */
    @ApiModelProperty(value = "文件名称，为空则使用原有名称", position = 3)
    private String newFileName;
}
