package com.el.coordinator.file.parameter;

import com.el.coordinator.file.vo.FileUploadInfoVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * <p>
 * 开始上传入参
 * </p >
 *
 * @author niu.chen
 * @date 2021/2/18
 */

@ApiModel("StartFileUploadParam[文件上传的入参]")
@Data
public class StartFileUploadParam<T>    implements Serializable {


    private static final long serialVersionUID = -5181677981823918830L;
    //fileCode 单据号
    @ApiModelProperty(value = "文件号", required = true)
     private String fileCode;

    //fileToKen 文件上传令牌
    @ApiModelProperty(value = "文件上传令牌", required = true)
     private String fileToKen;

    /**
     * 扩展信息
     */
    private T extraInfo;
//    @ApiModelProperty(value = "文件", required = true )
//     private MultipartFile multipartFile ;

//
//    @ApiModelProperty(value = "文件标识.用于更新,可选")
//    private String docCode;
}
