package com.el.coordinator.file.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 文件块信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/11
 */
@Data
@ApiModel(description = "文件块信息")
public class FileChunkSaveVO implements Serializable {
    private static final long serialVersionUID = -1499275951127832703L;

    /**
     * 上传记录标识
     */
    @ApiModelProperty(value = "上传记录标识", position = 1, required = true)
    @NotNull(message = "上传记录标识为空")
    private Long uploadId;

    /**
     * 是否是合并
     */
    @ApiModelProperty(value = "是否是合并操作", position = 2, required = true)
    @NotNull(message = "是否合并操作为空")
    private Boolean merge;

    /**
     * 分片号，从0开始计数
     */
    @ApiModelProperty(value = "分片号，从0开始计数", position = 3)
    private Integer partNumber;

}
