package com.el.coordinator.file.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文件上传返回
 * extends StartFileUploadVO
 *
 * @author niuchen
 * @since 2021/2/17
 */
@ApiModel("StartFileUploadVO[文件上传返回]")
public class StartFileUploadVO implements Serializable {

    private static final long serialVersionUID = -5142546837114942792L;

    @ApiModelProperty(value = "文件编码")
    private String fileCode;

    @ApiModelProperty(value = "文件编码父编码")
    private String fileCodeParent;

    @ApiModelProperty(value = "上传者编码")
    private String uploaderCode;

    /**
     * 租户ID 租户ID
     */
    @ApiModelProperty("租户标识'")
    private String tenant;
    @ApiModelProperty(value = "文件编号标识")
    private String docCode;

    @ApiModelProperty(value = "项目标识")
    private String project;

    @ApiModelProperty(value = "业务标识")
    private String business;

    @ApiModelProperty(value = "日期标识")
    private String dateFlag;

    @ApiModelProperty(value = "分组标识")
    private String groupFlag;

    @ApiModelProperty(value = "子文件标识，当parentFireCode不空时必填", position = 10)
    private String childFlag;

    @ApiModelProperty(value = "文件原名称")
    private String originalName;

    @ApiModelProperty(value = "上传类型 文件：file 图片：image 前端传入")
    private String type;

    @Column(name = "mime_type", columnDefinition = "varchar(256) comment '文件内容类型'")
    private String mimeType;

    @ApiModelProperty(value = "文件属性：1.动态文件 2.静态文件")
    private String attribute;

    @ApiModelProperty(value = "文件大小")
    private Long fileSize;

    @ApiModelProperty(value = "后缀名")
    private String suffix;

    @ApiModelProperty(value = "上传时间")
    private LocalDateTime created;

    @ApiModelProperty(value = "上传状态：0未删除 1.成功  -1失败")
    private int uploadStatus;

//    @ApiModelProperty(value = "文件上传名称")
//    private String uploadName;

    @ApiModelProperty(value = "文件目录")
    private String fileDirectoryPath;

    @ApiModelProperty(value = "文件地址")
    private String filePath;

    @ApiModelProperty(value = "web访问路径 静态文件地址")
    private String fileUrl;
    @ApiModelProperty(value = "web访问路径 静态文件地址2 业务系统设置使用")
    private String fileUrl2;
    @ApiModelProperty(value = "web访问路径 静态文件地址3 业务系统设置使用")
    private String fileUrl3;

    @ApiModelProperty(value = "外部可访问的完整链接")
    private String url;

    @ApiModelProperty(value = "动态文件路径-物理路径")
    private String downloadPath;
    @ApiModelProperty(value = "静态文件路径-物理路径")
    private String downloadPath2;


    @ApiModelProperty(value = "存储方式: 本地/FTP/云盘")
    private String storageType;
    @ApiModelProperty("扩展自定义属性1")
    private String attribute1;
    @ApiModelProperty("扩展自定义属性2")
    private String attribute2;
    @ApiModelProperty("扩展自定义属性3")
    private String attribute3;
    @ApiModelProperty("扩展自定义属性4")
    private String attribute4;
    @ApiModelProperty("扩展自定义属性5")
    private String attribute5;

    public StartFileUploadVO() {
    }

    public String getFileCode() {
        return fileCode;
    }

    public void setFileCode(String fileCode) {
        this.fileCode = fileCode;
    }

    public String getFileCodeParent() {
        return fileCodeParent;
    }

    public void setFileCodeParent(String fileCodeParent) {
        this.fileCodeParent = fileCodeParent;
    }

    public String getUploaderCode() {
        return uploaderCode;
    }

    public void setUploaderCode(String uploaderCode) {
        this.uploaderCode = uploaderCode;
    }

    public String getTenant() {
        return tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getDocCode() {
        return docCode;
    }

    public void setDocCode(String docCode) {
        this.docCode = docCode;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getDateFlag() {
        return dateFlag;
    }

    public void setDateFlag(String dateFlag) {
        this.dateFlag = dateFlag;
    }

    public String getGroupFlag() {
        return groupFlag;
    }

    public void setGroupFlag(String groupFlag) {
        this.groupFlag = groupFlag;
    }

    public String getChildFlag() {
        return childFlag;
    }

    public void setChildFlag(String childFlag) {
        this.childFlag = childFlag;
    }

    public String getOriginalName() {
        return originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getAttribute() {
        return attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public LocalDateTime getCreated() {
        return created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public int getUploadStatus() {
        return uploadStatus;
    }

    public void setUploadStatus(int uploadStatus) {
        this.uploadStatus = uploadStatus;
    }

    public String getFileDirectoryPath() {
        return fileDirectoryPath;
    }

    public void setFileDirectoryPath(String fileDirectoryPath) {
        this.fileDirectoryPath = fileDirectoryPath;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl2() {
        return fileUrl2;
    }

    public void setFileUrl2(String fileUrl2) {
        this.fileUrl2 = fileUrl2;
    }

    public String getFileUrl3() {
        return fileUrl3;
    }

    public void setFileUrl3(String fileUrl3) {
        this.fileUrl3 = fileUrl3;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDownloadPath() {
        return downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public String getDownloadPath2() {
        return downloadPath2;
    }

    public void setDownloadPath2(String downloadPath2) {
        this.downloadPath2 = downloadPath2;
    }

    public String getStorageType() {
        return storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }
}
