package com.el.coordinator.boot.fsm.config;

import com.el.coordinator.boot.fsm.common.StorageEnum;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

import java.time.Duration;
import java.util.List;

/**
 * 文件服务相关的配置文件.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-15
 */
@ConfigurationProperties(prefix = "elitesland.base.service.file")
public class FileConfigProperties {

    /**
     * 是否启用文件服务
     */
    private Boolean enable = true;

    /**
     * 存储类型
     */
    private StorageEnum storageType = StorageEnum.REMOTE;

    /**
     * 分片上传时最小分片大小，默认5MB
     */
    private DataSize chunkMin = DataSize.ofMegabytes(5);

    /**
     * 分片上传时最大分片大小，默认20MB
     */
    private DataSize chunkMax = DataSize.ofMegabytes(20);

    /**
     * 远程存储配置
     */
    private final StorageRemote remote = new StorageRemote();

    /**
     * 本地存储配置
     */
    private final StorageLocal local = new StorageLocal();

    /**
     * 上传文件黑名单后缀
     */
    private List<String> blockSuffixList;

    /**
     * 上传文件大小限制，为空表示无限制
     */
    private DataSize sizeLimit = DataSize.ofMegabytes(200);

    /**
     * 允许上传
     */
    private Boolean uploadEnabled = true;

    /**
     * 允许下载
     */
    private Boolean downloadEnabled = true;

    /**
     * 线程池配置
     */
    private final Thread thread = new Thread();

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public StorageEnum getStorageType() {
        return storageType;
    }

    public void setStorageType(StorageEnum storageType) {
        this.storageType = storageType;
    }

    public DataSize getChunkMin() {
        return chunkMin;
    }

    public void setChunkMin(DataSize chunkMin) {
        this.chunkMin = chunkMin;
    }

    public DataSize getChunkMax() {
        return chunkMax;
    }

    public void setChunkMax(DataSize chunkMax) {
        this.chunkMax = chunkMax;
    }

    public StorageRemote getRemote() {
        return remote;
    }

    public StorageLocal getLocal() {
        return local;
    }

    public List<String> getBlockSuffixList() {
        return blockSuffixList;
    }

    public void setBlockSuffixList(List<String> blockSuffixList) {
        this.blockSuffixList = blockSuffixList;
    }

    public DataSize getSizeLimit() {
        return sizeLimit;
    }

    public void setSizeLimit(DataSize sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public Thread getThread() {
        return thread;
    }

    public Boolean getUploadEnabled() {
        return uploadEnabled;
    }

    public void setUploadEnabled(Boolean uploadEnabled) {
        this.uploadEnabled = uploadEnabled;
    }

    public Boolean getDownloadEnabled() {
        return downloadEnabled;
    }

    public void setDownloadEnabled(Boolean downloadEnabled) {
        this.downloadEnabled = downloadEnabled;
    }

    public static class StorageRemote {
        /**
         * 文件服务器URL
         */
        private String serverUrl;

        /**
         * 项目标识
         */
        private String projectFlag;

        /**
         * 连接超时
         */
        private Duration serverConnectTimeout = Duration.ofSeconds(5);

        /**
         * 读取超时
         */
        private Duration serverReadTimeout = Duration.ofMinutes(1);

        public String getServerUrl() {
            return serverUrl;
        }

        public void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String getProjectFlag() {
            return projectFlag;
        }

        public void setProjectFlag(String projectFlag) {
            this.projectFlag = projectFlag;
        }

        public Duration getServerConnectTimeout() {
            return serverConnectTimeout;
        }

        public void setServerConnectTimeout(Duration serverConnectTimeout) {
            this.serverConnectTimeout = serverConnectTimeout;
        }

        public Duration getServerReadTimeout() {
            return serverReadTimeout;
        }

        public void setServerReadTimeout(Duration serverReadTimeout) {
            this.serverReadTimeout = serverReadTimeout;
        }
    }

    public static class StorageLocal {
        /**
         * 本地目录
         */
        private String path;

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Thread {
        /**
         * 核心线程数
         */
        private Integer coreThread = 10;

        /**
         * 最大线程数
         */
        private Integer maxThread = 64;

        /**
         * 等待队列的大小
         */
        private Integer queueSize = 256;
        /**
         * 现成的前缀
         */
        private String threadPrefix = "el-file-";

        public Integer getCoreThread() {
            return coreThread;
        }

        public void setCoreThread(Integer coreThread) {
            this.coreThread = coreThread;
        }

        public Integer getMaxThread() {
            return maxThread;
        }

        public void setMaxThread(Integer maxThread) {
            this.maxThread = maxThread;
        }

        public Integer getQueueSize() {
            return queueSize;
        }

        public void setQueueSize(Integer queueSize) {
            this.queueSize = queueSize;
        }

        public String getThreadPrefix() {
            return threadPrefix;
        }

        public void setThreadPrefix(String threadPrefix) {
            this.threadPrefix = threadPrefix;
        }
    }
}
