package com.el.coordinator.boot.fsm.config;

import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-21
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
@EnableSwagger2WebMvc
@Import(BeanValidatorPluginsConfiguration.class)
@Slf4j
public class SwaggerConfigFsmBoot {

    @Autowired
    private OpenApiExtensionResolver openApiExtensionResolver;
    @Autowired
    private ServerProperties serverProperties;

    /**
     * 标题
     */
    @Value("${swagger.title}")
    private String title;
    /**
     * 描述
     */
    @Value("${swagger.description}")
    private String description;
    /**
     * URL
     */
    @Value("${swagger.url}")
    private String url;

    @Bean
    public Docket createFsmRestApi() {
        String groupName = "FileServiceAPI";
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName(groupName)
                .apiInfo(apiInfo(groupName))
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.el.coordinator.boot.fsm.controller"))
                .paths(PathSelectors.any())
                .build()
//                .globalOperationParameters(List.of(parameterHeaderToken(ConstantsB2C.HEADER_APPLET_TOKEN, 0)))
                .extensions(openApiExtensionResolver.buildExtensions(groupName))
                ;
    }

    private ApiInfo apiInfo(String desc) {
        return new ApiInfoBuilder()
                .title(title)
                .description(description + "【" + desc + "】")
                .termsOfServiceUrl(getServiceUrl())
                .contact(new Contact("wang shao", "", "Kaiser.wang@elitesland.com"))
                .version("0.1.0")
                .build();
    }

    private String getServiceUrl() {
        if (StringUtils.isNotBlank(url)) {
            return url;
        }
        int port = Objects.requireNonNullElse(serverProperties.getPort(), 8080);
//        String contextPath = StringUtils.defaultIfBlank(serverProperties.getServlet().getContextPath(), "");
        return "http://" + getIp() + ":" + port;
    }

    private String getIp() {
        if (serverProperties.getAddress() != null) {
            return serverProperties.getAddress().getHostAddress();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            log.error("获取服务器IP失败", e);
        }
        return "127.0.0.1";
    }
}
