package com.el.coordinator.boot.fsm.config.handler;

import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.boot.fsm.common.FileTypeEnum;
import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.convert.FileConvert;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.dto.FileUploadDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.api.ApiResult;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
public abstract class AbstractFileHandler<T> implements Handlable<T> {

    /**
     * 文件下载路径
     */
    private final String URL_DOWNLOAD = "/com/file/v1/{fileCode}/download";
    /**
     * 文件删除路径
     */
    private final String URL_DELETE = "/com/file/v1/{fileCode}";
    /**
     * 图片预览路径
     */
    private final String URL_PREVIEW = "/com/file/v1/{fileCode}/show";

    private final FileConvert fileConvert = FileConvert.INSTANCE;

    @Override
    public ApiResult<FileObjRespVO<T>> beforeHandle(UploadFileParam<T> uploadFileParam) {
        return null;
    }

    @Override
    public ApiResult<FileObjRespVO<T>> afterHandle(UploadFileParam<T> uploadFileParam, FileObjDTO<T> fileObj, String errorMsg) {
        if (fileObj == null) {
            return ApiResult.fail("文件上传失败" + ObjectUtil.defaultIfBlank(errorMsg, "！"));
        }

        return ApiResult.ok(buildFileObjRespVO(uploadFileParam, fileObj));
    }

    @Override
    public FileUploadDTO<T> paramToUploadDTO(UploadFileParam<T> uploadFileParam) {
        FileUploadDTO<T> fileUploadDTO = new FileUploadDTO<>();
        fileUploadDTO.setFileParam(uploadFileParam);
        return fileUploadDTO;
    }

    @Override
    public FileObjRespVO<T> uploadDtoToRespVo(FileObjDTO<T> objDTO) {
        FileObjRespVO<T> fileObjRespVO = (FileObjRespVO<T>) fileConvert.dto2VO(objDTO);
        fileObjRespVO.setExtraInfo(objDTO.getExtraInfo());

        renderUrl(fileObjRespVO);

        return fileObjRespVO;
    }

    @Override
    public void fillFileObj(FileObjDTO<T> objDTO) {
    }

    private FileObjRespVO<T> buildFileObjRespVO(UploadFileParam<T> uploadFileParam, FileObjDTO<T> fileObj) {
        FileObjRespVO<T> respVO = (FileObjRespVO<T>) fileConvert.dto2VO(fileObj);
        respVO.setFileSize(uploadFileParam.getFileSize().toBytes());
        respVO.setExtraInfo(uploadFileParam.getExtraInfo());

        renderUrl(respVO);

        return respVO;
    }

    private void renderUrl(FileObjRespVO<T> respVO) {
        respVO.setUrlPreview(respVO.getFileType() == FileTypeEnum.IMAGE ? URL_PREVIEW.replace("{fileCode}", respVO.getFileCode()) : null);
        respVO.setUrlDownload(URL_DOWNLOAD.replace("{fileCode}", respVO.getFileCode()));
        respVO.setUrlDelete(URL_DELETE.replace("{fileCode}", respVO.getFileCode()));
    }
}
