package com.el.coordinator.boot.fsm.config.handler;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.boot.fsm.common.FileTypeEnum;
import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.dto.FileUploadDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.api.ApiResult;
import lombok.extern.slf4j.Slf4j;

import java.awt.image.BufferedImage;
import java.io.IOException;

/**
 * 默认文件处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@Slf4j
public class SimpleFileHandler<T> extends AbstractFileHandler<T> {

    @Override
    public ApiResult<FileObjRespVO<T>> afterHandle(UploadFileParam<T> uploadFileParam, FileObjDTO<T> fileObj, String errorMsg) {
        ApiResult<FileObjRespVO<T>> result = super.afterHandle(uploadFileParam, fileObj, errorMsg);
        if (!result.isSuccess()) {
            return result;
        }

        fillFileRespVO(result.getData(), fileObj);

        return result;
    }

    @Override
    public FileUploadDTO<T> paramToUploadDTO(UploadFileParam<T> uploadFileParam) {
        FileUploadDTO<T> uploadDTO = super.paramToUploadDTO(uploadFileParam);

        // 图片处理
        convertParamForImg(uploadFileParam, uploadDTO);
        return uploadDTO;
    }



    @Override
    public FileObjRespVO<T> uploadDtoToRespVo(FileObjDTO<T> objDTO) {
        FileObjRespVO<T> respVO = super.uploadDtoToRespVo(objDTO);

        // 图片处理
        convertRespForImg(objDTO, respVO);
        return respVO;
    }

    @Override
    public void fillFileObj(FileObjDTO<T> objDTO) {
        super.fillFileObj(objDTO);
    }

    private void fillFileRespVO(FileObjRespVO<T> respVO, FileObjDTO<T> fileObj) {
        if (respVO == null) {
            return;
        }
        // 图片处理
        convertRespForImg(fileObj, respVO);
    }

    private void convertParamForImg(UploadFileParam<T> uploadFileParam, FileUploadDTO<T> uploadDTO) {
        FileTypeEnum fileTypeEnum = uploadFileParam.getFileType();
        if (fileTypeEnum == null || fileTypeEnum != FileTypeEnum.IMAGE) {
            return;
        }

        try {
            BufferedImage image = ImgUtil.read(uploadFileParam.getUploadFile().getInputStream());
            uploadDTO.setAttribute1(image.getWidth() + "");
            uploadDTO.setAttribute2(image.getHeight() + "");
        } catch (Exception e) {
            log.error("获取图片的宽高失败：{}", e.getMessage());
        }
    }

    private void convertRespForImg(FileObjDTO<T> fileObj, FileObjRespVO<T> respVO) {
        FileTypeEnum fileTypeEnum = fileObj.getFileType();
        if (fileTypeEnum == null || fileTypeEnum != FileTypeEnum.IMAGE) {
            return;
        }

        if (StrUtil.isNotBlank(fileObj.getAttribute1())) {
            respVO.setWidth(Integer.valueOf(fileObj.getAttribute1()));
        }
        if (StrUtil.isNotBlank(fileObj.getAttribute2())) {
            respVO.setHeight(Integer.valueOf(fileObj.getAttribute2()));
        }
    }
}
