package com.el.coordinator.boot.fsm.config.validator;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.config.FileConfigProperties;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
public class BlockSuffixValidator<T> implements Validatable<T> {

    private final FileConfigProperties configProperties;

    public BlockSuffixValidator(FileConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public String validate(UploadFileParam<T> uploadFileParam) {
        if (CollectionUtil.isEmpty(configProperties.getBlockSuffixList())) {
            // 无限制
            return null;
        }
        if (StrUtil.isBlank(uploadFileParam.getSuffix())) {
            return "未知文件的类型";
        }

        if (configProperties.getBlockSuffixList().contains(uploadFileParam.getSuffix())) {
            return "该文件类型禁止上传";
        }
        return null;
    }
}
