package com.el.coordinator.boot.fsm.convert;

import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface FileConvert {

    FileConvert INSTANCE = Mappers.getMapper(FileConvert.class);

    /**
     * 上传的文件信息转VO
     *
     * @param uploadFileParam 上传的文件信息
     * @return 文件vo信息
     */
    @Mappings({
            @Mapping(target = "fileSize", ignore = true)
    })
    FileObjRespVO uploadFileParam2VO(UploadFileParam uploadFileParam);

    /**
     * dto复制到vo
     *
     * @param objDTO dto
     * @return vo
     */
    FileObjRespVO dto2VO(FileObjDTO objDTO);
}
