package com.el.coordinator.boot.fsm.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 导出结果.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/18
 */
@Data
@ApiModel(description = "导出结果")
@AllArgsConstructor
@NoArgsConstructor
public class ExportResultRespVO implements Serializable {
    private static final long serialVersionUID = 281694571450650791L;

    /**
     * 是否是同步导出
     */
    @ApiModelProperty(value = "是否是同步导出")
    private Boolean sync;

    /**
     * 导出记录的唯一标识
     */
    @ApiModelProperty(value = "导出记录的唯一标识")
    private Long recordId;

    /**
     * 总记录数
     */
    @ApiModelProperty(value = "总记录数")
    private Long total;
}
