package com.el.coordinator.boot.fsm.model.vo;

import com.el.coordinator.boot.fsm.common.FileTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文件信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@ApiModel(description = "文件信息返回对象")
@Data
public class FileObjRespVO<T> implements Serializable {

    /**
     * 文件编码，文件服务器上的文件唯一标
     */
    @ApiModelProperty(value = "文件编码，文件服务器上的文件唯一标识", position = 1)
    private String fileCode;

    /**
     * 文件原名称
     */
    @ApiModelProperty(value = "文件原名称", position = 2)
    private String originalName;

    /**
     * 文件大小，字节B
     */
    @ApiModelProperty(value = "文件大小，字节B", position = 3)
    private Long fileSize;

    /**
     * 文件名后缀
     */
    @ApiModelProperty(value = "文件名后缀", position = 4)
    private String suffix;

    /**
     * 文件内容类型，mime-type
     */
    @ApiModelProperty(value = "文件内容类型，mime-type", position = 5)
    private String mimeType;

    /**
     * 常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见
     */
    @ApiModelProperty(value = "常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见", position = 10)
    private FileTypeEnum fileType;

    /**
     * 上传时间
     */
    @ApiModelProperty(value = "上传时间", position = 11)
    private LocalDateTime uploadTime;

    /**
     * 文件路径
     */
    @ApiModelProperty(value = "文件路径", position = 12)
    private String filePath;

    /**
     * 宽度，图片时有值
     */
    @ApiModelProperty(value = "宽度，图片时有值", position = 20)
    private Integer width;

    /**
     * 高度，图片时有值
     */
    @ApiModelProperty(value = "高度，图片时有值", position = 21)
    private Integer height;

    /**
     * 文件预览url
     */
    @ApiModelProperty(value = "文件预览url", position = 30)
    private String urlPreview;

    /**
     * 文件下载url
     */
    @ApiModelProperty(value = "文件下载url", position = 31)
    private String urlDownload;

    /**
     * 文件删除url
     */
    @ApiModelProperty(value = "文件删除url", position = 32)
    private String urlDelete;

    /**
     * 外部可访问的完整链接
     */
    @ApiModelProperty(value = "外部可访问的完整链接", position = 33)
    private String url;

    /**
     * 扩展参数
     */
    @ApiModelProperty(value = "扩展参数", position = 40)
    private T extraInfo;
}
