package com.el.coordinator.boot.fsm.service;

import com.el.coordinator.boot.fsm.model.vo.ExportResultRespVO;
import com.el.coordinator.boot.fsm.model.vo.ImportRateRespVO;
import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;
import com.el.coordinator.core.common.api.ApiResult;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/3
 */
public interface DataChannelService {

    /**
     * 下载模板
     *
     * @param code 模板编码
     * @return 模板文件
     */
    ResponseEntity<InputStreamResource> downloadByCode(String code);

    /**
     * 导入数据
     *
     * @param code     模板编号
     * @param dataFile 数据文件
     * @return 导入结果
     */
    ApiResult<ImportResultRespVO> importData(String code, MultipartFile dataFile);

    /**
     * 导出数据
     *
     * @param code       模板编号
     * @param queryParam 查询参数
     * @return 导出结果
     */
    ApiResult<ExportResultRespVO> exportData(String code, Map<String, Object> queryParam);

    /**
     * 下载导出的数据文件
     *
     * @param id 记录ID
     * @return 文件
     */
    HttpEntity<StreamingResponseBody> downloadExportFile(Long id);

    /**
     * 获取导入（或导出）进度
     *
     * @param id 记录ID
     * @return 进度
     */
    ApiResult<ImportRateRespVO> getRate(Long id);
}
