package com.el.coordinator.boot.fsm.service.exportdata;

import com.el.coordinator.core.common.jpa.vo.PagingVO;

import java.io.Serializable;

/**
 * 数据导出服务.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/15
 * @deprecated 请使用 {@link com.elitescloud.boot.excel.common.DataExport}
 */
@Deprecated(forRemoval = true)
public interface DataExport<T extends Serializable, E extends Serializable> {

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @param page       页数，从1开始
     * @param pageSize   页大小
     * @return 数据
     */
    PagingVO<T> execute(E queryParam, int page, int pageSize);

    /**
     * 导出文件的名称
     *
     * @return 导出文件的名称
     */
    default String exportFileName() {
        return null;
    }

    /**
     * 分页查询时每次查询数量
     *
     * @return 页大小
     */
    default Integer pageSize() {
        return null;
    }
}
