package com.el.coordinator.boot.fsm.service.impl.exportstrategy;

import com.el.coordinator.boot.fsm.model.bo.ExportStrategyParam;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.boot.fsm.support.FsmTmplSupport;
import com.el.coordinator.core.common.constant.SheetLimitStrategy;
import com.el.coordinator.file.business.dto.TmplDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
@Component
public class ExportStrategyDelegate implements ExportStrategy {
    private final Map<SheetLimitStrategy, Constructor<? extends ExportStrategy>> strategyMap = new HashMap<>();

    @Autowired
    private FileService fileService;
    @Autowired
    private FsmTmplSupport fsmTmplSupport;

    public ExportStrategyDelegate() {
        init();
    }

    @Override
    public long export(ExportStrategyParam param) {
        // 获取sheet策略
        SheetLimitStrategy sheetLimitStrategy = obtainSheetStrategy(param.getTmplDTO());
        Constructor<? extends ExportStrategy> strategyClazz = strategyMap.get(sheetLimitStrategy);
        Assert.notNull(strategyClazz, "暂不支持的导出策略");

        ExportStrategy exportStrategy = null;
        try {
            exportStrategy = strategyClazz.newInstance(fileService, fsmTmplSupport);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }

        return exportStrategy.export(param);
    }

    private SheetLimitStrategy obtainSheetStrategy(TmplDTO tmplDTO) {
        if (!StringUtils.hasText(tmplDTO.getExportSheetStrategy())) {
            return SheetLimitStrategy.NEW_SHEET;
        }

        return SheetLimitStrategy.valueOf(tmplDTO.getExportSheetStrategy());
    }

    private void init() {
        try {
            Class<?>[] classes = {FileService.class, FsmTmplSupport.class};
            strategyMap.put(SheetLimitStrategy.IGNORE, IgnoreExportStrategy.class.getDeclaredConstructor(classes));
            strategyMap.put(SheetLimitStrategy.NEW_SHEET, NewSheetExportStrategy.class.getDeclaredConstructor(classes));
            strategyMap.put(SheetLimitStrategy.NEW_FILE, NewFileExportStrategy.class.getDeclaredConstructor(classes));
        } catch (NoSuchMethodException e) {
            throw new IllegalStateException("导出策略实现类缺少指定的构造方法", e);
        }
    }
}
