package com.el.coordinator.boot.fsm.common;

import lombok.Builder;
import lombok.Data;
import org.springframework.core.io.Resource;
import org.springframework.util.unit.DataSize;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * 上传文件的参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
@Data
@Builder
public class UploadFileParam<T> {

    /**
     * 上传时的其它参数
     */
    private final Map<String, String[]> uploadParam;
    /**
     * 上传的文件
     */
    private Resource uploadFile;

    /**
     * 文件大小
     */
    private DataSize fileSize;

    /**
     * 文件原始名称
     */
    private String originalName;

    /**
     * 文件后缀
     */
    private String suffix;

    /**
     * 文件类型
     */
    private String mimeType;

    /**
     * 常见的文件类型
     */
    private FileTypeEnum fileType;

    /**
     * 上传时间
     */
    private LocalDateTime uploadTime;

    /**
     * 扩展信息
     */
    private T extraInfo;
}
