package com.el.coordinator.boot.fsm.config;

import com.el.coordinator.boot.fsm.config.child.ChildProcessor;
import com.el.coordinator.boot.fsm.config.validator.Validatable;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-21
 */
public interface ElFsmConfigurationCustomizer<T> {

    /**
     * 自定义前置校验器
     * <p>
     * 文件上传前的校验和处理
     *
     * @return 自定义校验器
     */
    List<Validatable<T>> getValidators();

    /**
     * 自定义子文件处理器
     *
     * @return 子文件处理器
     */
    List<ChildProcessor<T>> getChildProcessors();
}
