package com.el.coordinator.boot.fsm.config.child;

import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.dto.FileUploadDTO;

import java.util.function.Function;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-19
 */
public interface ChildProcessor<T> {

    /**
     * 是否接受处理
     *
     * @param childType 子文件类型
     * @return 是否接受处理
     */
    boolean accept(String childType);

    /**
     * 处理子文件
     *
     * @param uploadFileParam 文件上传参数信息
     * @param parentFile      父文件的信息
     * @param uploadMethod    上传方法
     */
    void process(UploadFileParam<T> uploadFileParam, FileObjDTO<T> parentFile, Function<FileUploadDTO<T>, FileObjDTO<T>> uploadMethod);
}
