package com.el.coordinator.boot.fsm.config.handler;


import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.model.dto.FileObjDTO;
import com.el.coordinator.boot.fsm.model.dto.FileUploadDTO;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.api.ApiResult;

/**
 * 文件处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
public interface Handlable<T> {

    /**
     * 文件上传的前置处理器
     *
     * @param uploadFileParam 文件上传参数
     * @return 处理结果，如果不是null，则直接返回，否则继续往后处理
     */
    ApiResult<FileObjRespVO<T>> beforeHandle(UploadFileParam<T> uploadFileParam);

    /**
     * 文件上传的后置处理器
     *
     * @param uploadFileParam 文件上传参数
     * @param fileObj         文件上传后的信息
     * @param errorMsg        文件上传的失败信息
     * @return 处理结果
     */
    ApiResult<FileObjRespVO<T>> afterHandle(UploadFileParam<T> uploadFileParam, FileObjDTO<T> fileObj, String errorMsg);

    /**
     * 参数特殊转换处理
     *
     * @param uploadFileParam 文件上传参数
     * @return 上传参数
     */
    FileUploadDTO<T> paramToUploadDTO(UploadFileParam<T> uploadFileParam);

    /**
     * 文件信息转VO
     *
     * @param objDTO 文件信息
     * @return VO
     */
    FileObjRespVO<T> uploadDtoToRespVo(FileObjDTO<T> objDTO);

    /**
     * 文件信息转DTO
     *
     * @param objDTO 文件信息
     * @return dto
     */
    void fillFileObj(FileObjDTO<T> objDTO);
}
