package com.el.coordinator.boot.fsm.config.validator;

import com.el.coordinator.boot.fsm.common.UploadFileParam;
import com.el.coordinator.boot.fsm.config.FileConfigProperties;
import org.springframework.util.unit.DataSize;

/**
 * 文件大小校验器.
 *
 * @author Kaiser（wang shao）
 * @date 2021-04-18
 */
public class FileSizeValidator<T> implements Validatable<T> {

    private final FileConfigProperties configProperties;

    public FileSizeValidator(FileConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public String validate(UploadFileParam<T> uploadFileParam) {
        if (uploadFileParam.getFileSize() == null) {
            return "未知上传的文件大小";
        }
        DataSize sizeLimit = configProperties.getSizeLimit();
        if (sizeLimit == null) {
            // 为空表示无限制
            return null;
        }

        if (uploadFileParam.getFileSize().compareTo(sizeLimit) > 0) {
            return "上传文件过大，不得超过" + sizeLimit.toMegabytes() + "MB";
        }
        return null;
    }
}
